/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.InjectedContext;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class OrchestrationTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof MethodCall) {
            return Activator.getDefault().getImage("obj16/kind_methodCall.gif");
        }
        if (element instanceof PatternCall) {
            return Activator.getDefault().getImage("obj16/kind_patternCall.gif");
        }
        if (element instanceof PatternInjectedCall) {
            return Activator.getDefault().getImage("obj16/kind_patternInjectedCall.gif");
        }
        if (element instanceof SuperCall) {
            return Activator.getDefault().getImage("obj16/kind_superPatternCall.gif");
        }
        if (element instanceof BackCall) {
            return Activator.getDefault().getImage("obj16/kind_backCall.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof MethodCall) {
            MethodCall methodCall = (MethodCall)element;
            PatternMethod patternMethod = methodCall.getCalled();
            return String.valueOf(patternMethod == null ? "" : patternMethod.getName()) + Messages.OrchestrationTableLabelProvider_MethodCall;
        }
        if (element instanceof PatternCall) {
            PatternCall patternCall = (PatternCall)element;
            Pattern pattern = patternCall.getCalled();
            return String.valueOf(pattern == null ? "" : pattern.getName()) + Messages.OrchestrationTableLabelProvider_PatternCall;
        }
        if (element instanceof PatternInjectedCall) {
            PatternInjectedCall patternInjectedCall = (PatternInjectedCall)element;
            Pattern pattern = patternInjectedCall.getCalled();
            InjectedContext injectCtx = patternInjectedCall.getContext();
            return String.valueOf(pattern == null ? "" : String.valueOf(pattern.getName()) + " -> " + injectCtx.getName()) + Messages.OrchestrationTableLabelProvider_PatternInjectedCall;
        }
        if (element instanceof SuperCall) {
            return Messages.OrchestrationTableLabelProvider_SuperPatternCall;
        }
        if (element instanceof BackCall) {
            return Messages.OrchestrationTableLabelProvider_BackCall;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

