/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.emf.common.util.URI;

public abstract class EclipseFileReporter
implements PatternExecutionReporter {
    protected void writeOutput(String output, URI targetDirectoryURI, URI targetFileURI) {
        String targetDirectory = targetDirectoryURI.toString();
        String targetFile = targetFileURI.toString();
        this.writeOutput(output, targetDirectory, targetFile);
    }

    protected void writeOutput(String output, String targetDirectory, String targetFile) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            EclipseFileReporter.ensureContainerExists(targetDirectory, monitor);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetFile));
            if (file.exists()) {
                file.delete(true, (IProgressMonitor)monitor);
            }
            file.create((InputStream)new ByteArrayInputStream(output.getBytes()), true, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            EGFPatternPlugin.getDefault().logError(exception);
        }
    }

    protected static boolean ensureContainerExists(String workspacePath, NullProgressMonitor monitor) throws CoreException {
        Path path = new Path(workspacePath);
        IProject container = null;
        if (path.isAbsolute()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(path.segment(0));
            if (!project.exists()) {
                project.create((IProgressMonitor)monitor);
            }
            if (project.exists()) {
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)monitor);
                }
                container = project;
                int i = 1;
                int length = path.segmentCount();
                while (i < length) {
                    IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                    if (!folder.exists()) {
                        folder.create(false, true, (IProgressMonitor)monitor);
                    }
                    container = folder;
                    ++i;
                }
            }
        }
        return container != null && container.getFullPath().equals((Object)path);
    }
}

