/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.internal.registry;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.osgi.util.NLS;

public class PatternExtensionProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _nature;
    private String _class;
    private Object _executable;
    private String _name;

    public static PatternExtensionProxy createProxy(IConfigurationElement element) {
        String nature;
        if (element == null || !element.isValid()) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((nature = element.getAttribute("nature")) == null || nature.trim().length() == 0) {
            return null;
        }
        String clazz = element.getAttribute("class");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        return new PatternExtensionProxy(element, nature, clazz, uniqueIdentifier, handleId);
    }

    public PatternExtensionProxy(IConfigurationElement element, String nature, String clazz, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._nature = nature.trim();
        this._class = clazz.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public PatternExtension getPatternExtension() throws CoreException {
        if (this._executable == null && this._element.isValid()) {
            Object object = this._element.createExecutableExtension("class");
            if (object == null) {
                return null;
            }
            if (!(object instanceof PatternExtension)) {
                EGFPatternPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)PatternExtension.class.getName()), 1);
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            this._executable = object;
        }
        return (PatternExtension)this._executable;
    }

    public String getNature() {
        return this._nature;
    }

    public String getName() {
        if (this._name == null) {
            int index = this._nature.lastIndexOf(46);
            this._name = index == -1 ? this._nature : this._nature.substring(index + 1);
        }
        return this._name;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }
}

