/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.ftask.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.EGFFtaskPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.util.FcoreValidator;
import org.eclipse.egf.model.ftask.FtaskPackage;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.model.ftask.helper.TaskValidationHelper;
import org.eclipse.egf.model.ftask.task.ITaskNature;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtaskValidator
extends EObjectValidator {
    public static final FtaskValidator INSTANCE = new FtaskValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.ftask";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected FcoreValidator fcoreValidator = FcoreValidator.INSTANCE;

    public FtaskValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return FtaskPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateTask((Task)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateTask(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)task, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)task, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivity_PlatformFcore((Activity)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivity_MandatoryName((Activity)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivity_ActivityCycle((Activity)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_MandatoryKind(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_ValidKind(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_UselessTask(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_LoadableImplementation(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_ValidImplementation(task, diagnostics, context);
        }
        return result;
    }

    public boolean validateTask_MandatoryKind(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryKind", FtaskValidator.getObjectLabel((EObject)task, context), "Task kind is a mandatory value"}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTask_ValidKind(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
            return true;
        }
        if (!TaskValidationHelper.isValidKind(task.getKindValue())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidKind", FtaskValidator.getObjectLabel((EObject)task, context), NLS.bind((String)"This Task has an unknown kind ''{0}''", (Object)task.getKindValue().trim())}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTask_UselessTask(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getImplementationValue() == null || task.getImplementationValue().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessTask", FtaskValidator.getObjectLabel((EObject)task, context), "This Task has no implementation"}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTask_LoadableImplementation(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getImplementationValue() == null || task.getImplementationValue().trim().length() == 0 || task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
            return true;
        }
        ITaskNature taskNature = null;
        try {
            taskNature = EGFFtaskPlugin.getTaskNatureRegistry().getTaskNature(task);
        }
        catch (InvocationException ie) {
            return true;
        }
        if (!taskNature.isLoadableImplementation(task, context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"LoadableImplementation", FtaskValidator.getObjectLabel((EObject)task, context), NLS.bind((String)"Unable to load ''{0}''", (Object)task.getImplementationValue())}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTask_ValidImplementation(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getImplementationValue() == null || task.getImplementationValue().trim().length() == 0 || task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
            return true;
        }
        ITaskNature taskNature = null;
        try {
            taskNature = EGFFtaskPlugin.getTaskNatureRegistry().getTaskNature(task);
        }
        catch (InvocationException ie) {
            return true;
        }
        if (!taskNature.isValidImplementation(task, context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidImplementation", FtaskValidator.getObjectLabel((EObject)task, context), NLS.bind((String)"Type mismatch ''{0}'' with ''{1}''", (Object)ITaskProduction.class.getName(), (Object)task.getImplementationValue())}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFFtaskPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

