/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.ui.deploy;

import java.util.ArrayList;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.presentation.BuildCoreEditorPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeployDialog
extends Dialog {
    private String actionLabel;
    private Combo serverUrlCombo;
    private Combo jobNameCombo;
    private String serverUrl;
    private String jobName;

    public DeployDialog(Shell parentShell, String actionLabel, String initialServerUrl, String initialJobName) {
        super(parentShell);
        this.actionLabel = actionLabel;
        this.serverUrl = initialServerUrl;
        this.jobName = initialJobName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.marginBottom = 5;
        gl_container.marginTop = 5;
        gl_container.marginRight = 5;
        gl_container.marginLeft = 5;
        container.setLayout((Layout)gl_container);
        Label actionLabel = new Label(container, 0);
        actionLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        actionLabel.setText(this.actionLabel);
        Label serverUrlLabel = new Label(container, 0);
        GridData gd_ServerUrlLabel = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_ServerUrlLabel.widthHint = 77;
        serverUrlLabel.setLayoutData((Object)gd_ServerUrlLabel);
        serverUrlLabel.setText("Server URL :");
        this.serverUrlCombo = new Combo(container, 0);
        this.serverUrlCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label jobNameLabel = new Label(container, 0);
        jobNameLabel.setText("Job name :");
        this.jobNameCombo = new Combo(container, 0);
        this.jobNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.loadSettings();
        return container;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getJobName() {
        return this.jobName;
    }

    private void loadSettings() {
        this.loadCombo(this.serverUrlCombo, this.serverUrl, "deployServerUrls");
        this.loadCombo(this.jobNameCombo, this.jobName, "deployJobNames");
    }

    private void loadCombo(Combo combo, String initialValue, String settingsFieldName) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(initialValue);
        String[] settingsValues = BuildCoreEditorPlugin.getPlugin().getDialogSettings().getArray(settingsFieldName);
        if (settingsValues != null) {
            String[] stringArray = settingsValues;
            int n = settingsValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!values.contains(value)) {
                    values.add(value);
                }
                ++n2;
            }
        }
        combo.setItems(values.toArray(new String[0]));
        combo.select(0);
    }

    private void saveSettings() {
        this.serverUrl = this.saveCombo(this.serverUrlCombo, "deployServerUrls");
        this.jobName = this.saveCombo(this.jobNameCombo, "deployJobNames");
    }

    private String saveCombo(Combo combo, String settingsFieldName) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(combo.getText());
        String[] stringArray = combo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!values.contains(value)) {
                values.add(value);
            }
            ++n2;
        }
        BuildCoreEditorPlugin.getPlugin().getDialogSettings().put(settingsFieldName, values.toArray(new String[0]));
        return (String)values.get(0);
    }

    protected void okPressed() {
        this.saveSettings();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(483, 158);
    }
}

