/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.BoxLayouterOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class BoxLayoutProvider
extends AbstractLayoutProvider {
    public static final double DEF_ASPECT_RATIO = 1.3;

    @Override
    public void layout(ElkNode layoutNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Box layout", 2.0f);
        float objSpacing = ((Double)layoutNode.getProperty(BoxLayouterOptions.SPACING_NODE_NODE)).floatValue();
        ElkPadding padding = (ElkPadding)layoutNode.getProperty(BoxLayouterOptions.PADDING);
        boolean expandNodes = (Boolean)layoutNode.getProperty(BoxLayouterOptions.EXPAND_NODES);
        boolean interactive = (Boolean)layoutNode.getProperty(BoxLayouterOptions.INTERACTIVE);
        PackingMode mode = (PackingMode)((Object)layoutNode.getProperty(BoxLayouterOptions.BOX_PACKING_MODE));
        switch (mode) {
            case SIMPLE: {
                List<ElkNode> sortedBoxes = this.sort(layoutNode, interactive);
                this.placeBoxes(sortedBoxes, layoutNode, objSpacing, padding, expandNodes);
                break;
            }
            default: {
                this.placeBoxesGrouping(layoutNode, objSpacing, padding, expandNodes);
            }
        }
        progressMonitor.done();
    }

    private List<ElkNode> sort(ElkNode parentNode, final boolean interactive) {
        LinkedList<ElkNode> sortedBoxes = new LinkedList<ElkNode>((Collection<ElkNode>)parentNode.getChildren());
        Collections.sort(sortedBoxes, new Comparator<ElkNode>(){

            @Override
            public int compare(ElkNode child1, ElkNode child2) {
                Integer prio2;
                Integer prio1 = (Integer)child1.getProperty(BoxLayouterOptions.PRIORITY);
                if (prio1 == null) {
                    prio1 = 0;
                }
                if ((prio2 = (Integer)child2.getProperty(BoxLayouterOptions.PRIORITY)) == null) {
                    prio2 = 0;
                }
                if (prio1 > prio2) {
                    return -1;
                }
                if (prio1 < prio2) {
                    return 1;
                }
                if (interactive) {
                    int c = Double.compare(child1.getY(), child2.getY());
                    if (c != 0) {
                        return c;
                    }
                    c = Double.compare(child1.getX(), child2.getX());
                    if (c != 0) {
                        return c;
                    }
                }
                double size1 = child1.getWidth() * child1.getHeight();
                double size2 = child2.getWidth() * child2.getHeight();
                return Double.compare(size1, size2);
            }
        });
        return sortedBoxes;
    }

    private void placeBoxes(List<ElkNode> sortedBoxes, ElkNode parentNode, double objSpacing, ElkPadding padding, boolean expandNodes) {
        double minHeight;
        double minWidth;
        KVector minSize = (KVector)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MINIMUM);
        if (minSize == null) {
            minWidth = (Double)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MIN_WIDTH);
            minHeight = (Double)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MIN_HEIGHT);
        } else {
            minWidth = (float)minSize.x;
            minHeight = (float)minSize.y;
        }
        minWidth = Math.max(minWidth - padding.getLeft() - padding.getRight(), 0.0);
        minHeight = Math.max(minHeight - padding.getTop() - padding.getBottom(), 0.0);
        Double aspectRatio = (Double)parentNode.getProperty(BoxLayouterOptions.ASPECT_RATIO);
        if (aspectRatio == null || aspectRatio <= 0.0) {
            aspectRatio = 1.3;
        }
        KVector parentSize = this.placeBoxes(sortedBoxes, objSpacing, padding, minWidth, minHeight, expandNodes, aspectRatio);
        ElkUtil.resizeNode(parentNode, parentSize.x, parentSize.y, false, true);
    }

    private KVector placeBoxes(List<ElkNode> sortedBoxes, double minSpacing, ElkPadding padding, double minTotalWidth, double minTotalHeight, boolean expandNodes, double aspectRatio) {
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (ElkNode box : sortedBoxes) {
            ElkUtil.resizeNode(box);
            maxRowWidth = Math.max(maxRowWidth, box.getWidth());
            totalArea += box.getWidth() * box.getHeight();
        }
        double mean = totalArea / (double)sortedBoxes.size();
        double stddev = this.areaStdDev(sortedBoxes, mean);
        maxRowWidth = (double)((float)Math.max(maxRowWidth, Math.sqrt((totalArea += (double)(sortedBoxes.size() * 1) * stddev) * aspectRatio))) + padding.getLeft();
        double xpos = padding.getLeft();
        double ypos = padding.getTop();
        double highestBox = 0.0;
        double broadestRow = padding.getHorizontal();
        LinkedList<Integer> rowIndices = new LinkedList<Integer>();
        rowIndices.add(0);
        LinkedList<Double> rowHeights = new LinkedList<Double>();
        ListIterator<ElkNode> boxIter = sortedBoxes.listIterator();
        while (boxIter.hasNext()) {
            ElkNode box = boxIter.next();
            double width = box.getWidth();
            double height = box.getHeight();
            if (xpos + width > maxRowWidth) {
                if (expandNodes) {
                    rowHeights.addLast(highestBox);
                    rowIndices.addLast(boxIter.previousIndex());
                }
                xpos = padding.getLeft();
                ypos += highestBox + minSpacing;
                highestBox = 0.0;
                broadestRow = Math.max(broadestRow, padding.getHorizontal() + width);
            }
            box.setLocation(xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + width + padding.getRight());
            highestBox = Math.max(highestBox, height);
            xpos += width + minSpacing;
        }
        broadestRow = Math.max(broadestRow, minTotalWidth);
        double totalHeight = ypos + highestBox + padding.getBottom();
        if (totalHeight < minTotalHeight) {
            highestBox += minTotalHeight - totalHeight;
            totalHeight = minTotalHeight;
        }
        if (expandNodes) {
            xpos = padding.getLeft();
            boxIter = sortedBoxes.listIterator();
            rowIndices.addLast(sortedBoxes.size());
            ListIterator rowIndexIter = rowIndices.listIterator();
            int nextRowIndex = (Integer)rowIndexIter.next();
            rowHeights.addLast(highestBox);
            ListIterator rowHeightIter = rowHeights.listIterator();
            double rowHeight = 0.0;
            while (boxIter.hasNext()) {
                if (boxIter.nextIndex() == nextRowIndex) {
                    xpos = padding.getLeft();
                    rowHeight = (Double)rowHeightIter.next();
                    nextRowIndex = (Integer)rowIndexIter.next();
                }
                ElkNode box = boxIter.next();
                box.setHeight(rowHeight);
                if (boxIter.nextIndex() == nextRowIndex) {
                    double newWidth = broadestRow - xpos - padding.getRight();
                    double oldWidth = box.getWidth();
                    box.setWidth(newWidth);
                    ElkUtil.translate(box, (newWidth - oldWidth) / 2.0, 0.0);
                }
                xpos += box.getWidth() + minSpacing;
            }
        }
        return new KVector(broadestRow, totalHeight);
    }

    private double areaStdDev(List<ElkNode> boxes, double mean) {
        double variance = 0.0;
        for (ElkNode box : boxes) {
            variance += Math.pow(box.getWidth() * box.getHeight() - mean, 2.0);
        }
        double stddev = Math.sqrt(variance / (double)(boxes.size() - 1));
        return stddev;
    }

    private void placeBoxesGrouping(ElkNode parentNode, float objSpacing, ElkPadding padding, boolean expandNodes) {
        List<Group> toBePlaced;
        double minHeight;
        double minWidth;
        KVector minSize = (KVector)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MINIMUM);
        if (minSize == null) {
            minWidth = (Double)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MIN_WIDTH);
            minHeight = (Double)parentNode.getProperty(BoxLayouterOptions.NODE_SIZE_MIN_HEIGHT);
        } else {
            minWidth = (float)minSize.x;
            minHeight = (float)minSize.y;
        }
        minWidth = Math.max(minWidth - padding.getLeft() - padding.getRight(), 0.0);
        minHeight = Math.max(minHeight - padding.getTop() - padding.getBottom(), 0.0);
        Double aspectRatio = (Double)parentNode.getProperty(BoxLayouterOptions.ASPECT_RATIO);
        if (aspectRatio == null || aspectRatio <= 0.0) {
            aspectRatio = 1.3;
        }
        LinkedList groups = Lists.newLinkedList();
        for (ElkNode node : parentNode.getChildren()) {
            Group g = new Group(node);
            groups.add(g);
        }
        PackingMode mode = (PackingMode)((Object)parentNode.getProperty(BoxLayouterOptions.BOX_PACKING_MODE));
        switch (mode) {
            case GROUP_INC: {
                toBePlaced = this.mergeAndPlaceInc(groups, objSpacing, minWidth, minHeight, expandNodes, aspectRatio);
                break;
            }
            case GROUP_DEC: {
                toBePlaced = this.mergeAndPlaceDec(groups, objSpacing, minWidth, minHeight, expandNodes, aspectRatio);
                break;
            }
            default: {
                toBePlaced = this.mergeAndPlaceMixed(groups, objSpacing, minWidth, minHeight, expandNodes, aspectRatio);
            }
        }
        Group finalGroup = new Group(toBePlaced);
        KVector parentSize = this.placeInnerBoxes(finalGroup, objSpacing, padding, minWidth, minHeight, expandNodes, aspectRatio);
        ElkUtil.resizeNode(parentNode, parentSize.x, parentSize.y, false, true);
    }

    private KVector placeInnerBoxes(Group group, double minSpacing, ElkPadding padding, double minTotalWidth, double minTotalHeight, boolean expandNodes, double aspectRatio) {
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (Group box : group.groups) {
            if (box.node != null) {
                ElkUtil.resizeNode(box.node);
            }
            maxRowWidth = Math.max(maxRowWidth, box.getWidth());
            totalArea += box.getWidth() * box.getHeight();
        }
        double mean = totalArea / (double)group.groups.size();
        double stddev = this.areaStdDev2(group.groups, mean);
        double sdInfluence = 1.0;
        maxRowWidth = Math.max(maxRowWidth, Math.sqrt((totalArea += (double)group.groups.size() * sdInfluence * stddev) * aspectRatio)) + padding.getLeft();
        double xpos = padding.getLeft();
        double ypos = padding.getTop();
        double highestBox = 0.0;
        double broadestRow = padding.getHorizontal();
        LinkedList<Integer> rowIndices = new LinkedList<Integer>();
        rowIndices.add(0);
        LinkedList<Double> rowHeights = new LinkedList<Double>();
        ListIterator<Group> boxIter = group.groups.listIterator();
        Group last = null;
        ArrayList bottoms = Lists.newArrayList();
        while (boxIter.hasNext()) {
            Group box = boxIter.next();
            double width = box.getWidth();
            double height = box.getHeight();
            if (xpos + width > maxRowWidth) {
                if (expandNodes) {
                    rowHeights.addLast(highestBox);
                    rowIndices.addLast(boxIter.previousIndex());
                    group.right.add(last);
                    bottoms.clear();
                }
                xpos = padding.getLeft();
                ypos += highestBox + minSpacing;
                highestBox = 0.0;
                broadestRow = Math.max(broadestRow, padding.getHorizontal() + width);
            }
            bottoms.add(box);
            box.translate(xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + width + padding.getRight());
            highestBox = Math.max(highestBox, height);
            xpos += width + minSpacing;
            last = box;
        }
        group.bottom.addAll(bottoms);
        group.right.add((Group)bottoms.get(bottoms.size() - 1));
        broadestRow = Math.max(broadestRow, minTotalWidth);
        double totalHeight = ypos + highestBox + padding.getBottom();
        if (totalHeight < minTotalHeight) {
            highestBox += minTotalHeight - totalHeight;
            totalHeight = minTotalHeight;
        }
        if (expandNodes) {
            xpos = padding.getLeft();
            boxIter = group.groups.listIterator();
            rowIndices.addLast(group.groups.size());
            ListIterator rowIndexIter = rowIndices.listIterator();
            int nextRowIndex = (Integer)rowIndexIter.next();
            rowHeights.addLast(highestBox);
            ListIterator rowHeightIter = rowHeights.listIterator();
            double rowHeight = 0.0;
            while (boxIter.hasNext()) {
                if (boxIter.nextIndex() == nextRowIndex) {
                    xpos = padding.getLeft();
                    rowHeight = (Double)rowHeightIter.next();
                    nextRowIndex = (Integer)rowIndexIter.next();
                }
                Group box = boxIter.next();
                box.setHeight(rowHeight);
                if (boxIter.nextIndex() == nextRowIndex) {
                    double newWidth = broadestRow - xpos - padding.getRight();
                    double oldWidth = box.getWidth();
                    box.setWidth(newWidth);
                    box.translateInnerNodes((newWidth - oldWidth) / 2.0, 0.0);
                }
                xpos += box.getWidth() + minSpacing;
            }
        }
        return new KVector(broadestRow, totalHeight);
    }

    private double areaStdDev2(List<Group> boxes, double mean) {
        double variance = 0.0;
        for (Group box : boxes) {
            variance += Math.pow(box.area() - mean, 2.0);
        }
        double stddev = Math.sqrt(variance / (double)(boxes.size() - 1));
        return stddev;
    }

    private List<Group> mergeAndPlaceDec(List<Group> groups, double objSpacing, double minWidth, double minHeight, boolean expandNodes, double aspectRatio) {
        Collections.sort(groups, (g1, g2) -> -Double.compare(g1.area(), g2.area()));
        LinkedList boxQueue = Lists.newLinkedList(groups);
        ArrayList toBePlaced = Lists.newArrayList();
        ArrayList maybeGroup = Lists.newArrayList();
        Group boxToBeat = null;
        double collectedArea = 0.0;
        while (!boxQueue.isEmpty()) {
            Group box = (Group)boxQueue.poll();
            if (boxToBeat == null || boxToBeat.area() / 2.0 < box.area()) {
                boxToBeat = box;
                toBePlaced.add(box);
                continue;
            }
            collectedArea += box.area();
            maybeGroup.add(box);
            if (maybeGroup.size() <= 1 || !(collectedArea > boxToBeat.area() / 2.0) && !boxQueue.isEmpty()) continue;
            Group innerGroup = new Group(maybeGroup);
            double innerAspectRatio = boxToBeat.getWidth() / boxToBeat.getHeight();
            KVector groupSize = this.placeInnerBoxes(innerGroup, objSpacing, new ElkPadding(), minWidth, minHeight, expandNodes, innerAspectRatio);
            innerGroup.size.reset().add(groupSize);
            boxToBeat = innerGroup;
            toBePlaced.add(innerGroup);
            collectedArea = 0.0;
            maybeGroup.clear();
        }
        toBePlaced.addAll(maybeGroup);
        return toBePlaced;
    }

    private List<Group> mergeAndPlaceMixed(List<Group> groups, double objSpacing, double minWidth, double minHeight, boolean expandNodes, double aspectRatio) {
        double[] cumAreaArray = new double[groups.size()];
        PriorityQueue<Group> pq = new PriorityQueue<Group>((g1, g2) -> Double.compare(g1.area(), g2.area()));
        pq.addAll(groups);
        int index = 0;
        ArrayList toBePlaced = Lists.newArrayList();
        while (!pq.isEmpty()) {
            Group box = (Group)pq.peek();
            if (index > 1 && box.area() / 2.0 > cumAreaArray[0]) {
                int anIndex = 0;
                while (anIndex < toBePlaced.size() - 1 && box.area() / 2.0 > cumAreaArray[anIndex]) {
                    ++anIndex;
                }
                List<Group> select = toBePlaced.subList(0, anIndex + 1);
                Group innerGroup = new Group(select);
                double innerAspectRatio = box.getWidth() / box.getHeight();
                KVector groupSize = this.placeInnerBoxes(innerGroup, objSpacing, new ElkPadding(), minWidth, minHeight, expandNodes, innerAspectRatio);
                innerGroup.size.reset().add(groupSize);
                pq.add(innerGroup);
                List remain = toBePlaced.subList(anIndex + 1, toBePlaced.size());
                pq.addAll(remain);
                toBePlaced.clear();
                index = 0;
                Arrays.fill(cumAreaArray, 0.0);
                continue;
            }
            pq.poll();
            if (index > 0) {
                cumAreaArray[index] = cumAreaArray[index - 1];
            }
            int n = index++;
            cumAreaArray[n] = cumAreaArray[n] + box.area();
            toBePlaced.add(box);
        }
        return toBePlaced;
    }

    private List<Group> mergeAndPlaceInc(List<Group> groups, double objSpacing, double minWidth, double minHeight, boolean expandNodes, double aspectRatio) {
        Collections.sort(groups, (g1, g2) -> Double.compare(g1.area(), g2.area()));
        ListIterator<Group> groupIterator = groups.listIterator();
        ArrayList toBePlaced = Lists.newArrayList();
        double commonArea = 0.0;
        while (groupIterator.hasNext()) {
            Group g = groupIterator.next();
            if (!toBePlaced.isEmpty() && g.area() > commonArea * 2.0) {
                Group merged = new Group(toBePlaced);
                double innerAspectRatio = g.getWidth() / g.getHeight();
                KVector groupSize = this.placeInnerBoxes(merged, objSpacing, new ElkPadding(), minWidth, minHeight, expandNodes, innerAspectRatio);
                merged.size.reset().add(groupSize);
                toBePlaced.clear();
                commonArea = 0.0;
                toBePlaced.add(merged);
                toBePlaced.add(g);
                commonArea = merged.area() + g.area();
                continue;
            }
            toBePlaced.add(g);
            commonArea += g.area();
        }
        return toBePlaced;
    }

    private class Group {
        ElkNode node;
        List<Group> groups;
        KVector size;
        List<Group> bottom;
        List<Group> right;

        Group(ElkNode node) {
            this.node = node;
            node.setLocation(0.0, 0.0);
        }

        Group(Iterable<Group> groups) {
            this.groups = Lists.newArrayList(groups);
            this.bottom = Lists.newArrayList();
            this.right = Lists.newArrayList();
            this.size = new KVector();
        }

        public double area() {
            return this.getWidth() * this.getHeight();
        }

        public double getWidth() {
            if (this.node != null) {
                return this.node.getWidth();
            }
            return (float)this.size.x;
        }

        public double getHeight() {
            if (this.node != null) {
                return this.node.getHeight();
            }
            return (float)this.size.y;
        }

        public void setWidth(double w) {
            assert (w > this.getWidth());
            if (this.node != null) {
                this.node.setWidth(w);
            } else {
                double delta = w - this.getWidth();
                for (Group g : this.right) {
                    g.setWidth(g.getWidth() + delta);
                }
            }
        }

        public void setHeight(double h) {
            assert (h > this.getHeight());
            if (this.node != null) {
                this.node.setHeight(h);
            } else {
                double delta = h - this.getHeight();
                for (Group g : this.bottom) {
                    g.setHeight(g.getHeight() + delta);
                }
            }
        }

        public void translate(double x, double y) {
            if (this.node != null) {
                this.node.setX(this.node.getX() + x);
                this.node.setY(this.node.getY() + y);
            } else {
                for (Group g : this.groups) {
                    g.translate(x, y);
                }
            }
        }

        public void translateInnerNodes(double x, double y) {
            if (this.node != null) {
                ElkUtil.translate(this.node, x, y);
            } else {
                for (Group g : this.groups) {
                    g.translateInnerNodes(x, y);
                }
            }
        }

        public String toString() {
            if (this.node != null) {
                return this.node.toString();
            }
            return this.groups.toString();
        }
    }

    public static enum PackingMode {
        SIMPLE,
        GROUP_DEC,
        GROUP_MIXED,
        GROUP_INC;

    }
}

