/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.labelspacing;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.labelspacing.LabelGroup;
import org.eclipse.elk.core.util.labelspacing.LabelLocation;
import org.eclipse.elk.core.util.nodespacing.Rectangle;

public final class LabelSpaceCalculation {
    private LabelSpaceCalculation() {
    }

    public static ElkPadding calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing) {
        ElkPadding nodeLabelPadding = node.getProperty(CoreOptions.NODE_LABELS_PADDING);
        return LabelSpaceCalculation.calculateRequiredNodeLabelSpace(node, labelSpacing, nodeLabelPadding, new HashMap<LabelLocation, LabelGroup>(), new ElkPadding(node.getPadding()));
    }

    public static ElkPadding calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing, ElkPadding nodeLabelPadding, Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, ElkPadding padding) {
        Rectangle boundingBox;
        if (!node.getLabels().iterator().hasNext()) {
            return padding;
        }
        Set nodeLabelPlacement = node.getProperty(CoreOptions.NODE_LABELS_PLACEMENT);
        LabelLocation nodeLabelLocation = LabelLocation.fromNodeLabelPlacement(nodeLabelPlacement);
        for (GraphAdapters.LabelAdapter<?> label : node.getLabels()) {
            LabelLocation labelPlacement = LabelLocation.fromNodeLabelPlacement((Set<NodeLabelPlacement>)label.getProperty(CoreOptions.NODE_LABELS_PLACEMENT));
            if (labelPlacement == LabelLocation.UNDEFINED) {
                labelPlacement = nodeLabelLocation;
            }
            label.setVolatileId(labelPlacement.ordinal());
            boundingBox = LabelSpaceCalculation.retrieveLabelGroupsBoundingBox(labelGroupsBoundingBoxes, labelPlacement);
            boundingBox.width = Math.max(boundingBox.width, label.getSize().x);
            boundingBox.height += label.getSize().y + labelSpacing;
        }
        boolean hPrio = nodeLabelPlacement.contains((Object)NodeLabelPlacement.H_PRIORITY);
        for (Map.Entry<LabelLocation, LabelGroup> entry : labelGroupsBoundingBoxes.entrySet()) {
            boundingBox = entry.getValue();
            boundingBox.height -= labelSpacing;
            switch (entry.getKey()) {
                case IN_T_L: {
                    if (hPrio) {
                        padding.left = Math.max(padding.left, boundingBox.width + labelSpacing + nodeLabelPadding.left);
                        break;
                    }
                    padding.top = Math.max(padding.top, boundingBox.height + labelSpacing + nodeLabelPadding.top);
                    break;
                }
                case IN_T_C: {
                    padding.top = Math.max(padding.top, boundingBox.height + labelSpacing + nodeLabelPadding.top);
                    break;
                }
                case IN_T_R: {
                    if (hPrio) {
                        padding.right = Math.max(padding.right, boundingBox.width + labelSpacing + nodeLabelPadding.right);
                        break;
                    }
                    padding.top = Math.max(padding.top, boundingBox.height + labelSpacing + nodeLabelPadding.top);
                    break;
                }
                case IN_C_L: {
                    padding.left = Math.max(padding.left, boundingBox.width + labelSpacing + nodeLabelPadding.left);
                    break;
                }
                case IN_C_R: {
                    padding.right = Math.max(padding.right, boundingBox.width + labelSpacing + nodeLabelPadding.right);
                    break;
                }
                case IN_B_L: {
                    if (hPrio) {
                        padding.left = Math.max(padding.left, boundingBox.width + labelSpacing + nodeLabelPadding.left);
                        break;
                    }
                    padding.bottom = Math.max(padding.bottom, boundingBox.height + labelSpacing + nodeLabelPadding.bottom);
                    break;
                }
                case IN_B_C: {
                    padding.bottom = Math.max(padding.bottom, boundingBox.height + labelSpacing + nodeLabelPadding.bottom);
                    break;
                }
                case IN_B_R: {
                    if (hPrio) {
                        padding.right = Math.max(padding.right, boundingBox.width + labelSpacing + nodeLabelPadding.right);
                        break;
                    }
                    padding.bottom = Math.max(padding.bottom, boundingBox.height + labelSpacing + nodeLabelPadding.bottom);
                }
            }
        }
        padding.top = Math.max(padding.top, nodeLabelPadding.top);
        padding.left = Math.max(padding.left, nodeLabelPadding.left);
        padding.right = Math.max(padding.right, nodeLabelPadding.right);
        padding.bottom = Math.max(padding.bottom, nodeLabelPadding.bottom);
        return padding;
    }

    private static Rectangle retrieveLabelGroupsBoundingBox(Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, LabelLocation location) {
        if (!labelGroupsBoundingBoxes.containsKey((Object)location)) {
            LabelGroup boundingBox = new LabelGroup();
            labelGroupsBoundingBoxes.put(location, boundingBox);
            return boundingBox;
        }
        return labelGroupsBoundingBoxes.get((Object)location);
    }
}

