/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force;

import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.force.ComponentsProcessor;
import org.eclipse.elk.alg.force.ElkGraphImporter;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.model.AbstractForceModel;
import org.eclipse.elk.alg.force.model.EadesModel;
import org.eclipse.elk.alg.force.model.ForceModelStrategy;
import org.eclipse.elk.alg.force.model.FruchtermanReingoldModel;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.alg.force.properties.InternalProperties;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public final class ForceLayoutProvider
extends AbstractLayoutProvider {
    private AbstractForceModel forceModel;
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();

    public void layout(ElkNode kgraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("ELK Force", 1.0f);
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        FGraph fgraph = graphImporter.importGraph(kgraph);
        this.setOptions(fgraph, kgraph);
        this.updateModel((ForceModelStrategy)((Object)fgraph.getProperty(ForceOptions.MODEL)));
        List<FGraph> components = this.componentsProcessor.split(fgraph);
        for (FGraph comp : components) {
            this.forceModel.layout(comp, progressMonitor.subTask(1.0f / (float)components.size()));
        }
        fgraph = this.componentsProcessor.recombine(components);
        graphImporter.applyLayout(fgraph);
        progressMonitor.done();
    }

    private void setOptions(FGraph fgraph, ElkNode parent) {
        Integer randomSeed = (Integer)fgraph.getProperty(ForceOptions.RANDOM_SEED);
        if (randomSeed != null) {
            int val = randomSeed;
            if (val == 0) {
                fgraph.setProperty(InternalProperties.RANDOM, new Random());
            } else {
                fgraph.setProperty(InternalProperties.RANDOM, new Random(val));
            }
        } else {
            fgraph.setProperty(InternalProperties.RANDOM, new Random(1L));
        }
    }

    private void updateModel(ForceModelStrategy strategy) {
        switch (strategy) {
            case EADES: {
                if (this.forceModel instanceof EadesModel) break;
                this.forceModel = new EadesModel();
                break;
            }
            case FRUCHTERMAN_REINGOLD: {
                if (this.forceModel instanceof FruchtermanReingoldModel) break;
                this.forceModel = new FruchtermanReingoldModel();
            }
        }
    }
}

