/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.mrtree.ILayoutPhase;
import org.eclipse.elk.alg.mrtree.ILayoutProcessor;
import org.eclipse.elk.alg.mrtree.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.p1treeify.DFSTreeifyer;
import org.eclipse.elk.alg.mrtree.p2order.OrderBalance;
import org.eclipse.elk.alg.mrtree.p3place.NodePlacer;
import org.eclipse.elk.alg.mrtree.p4route.EdgeRouter;
import org.eclipse.elk.alg.mrtree.properties.MrTreeOptions;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class MrTree {
    private ILayoutPhase dfsTreeifyer;
    private ILayoutPhase nodeOrderer;
    private ILayoutPhase nodePlacer;
    private ILayoutPhase edgeRouter;
    private IntermediateProcessingConfiguration intermediateProcessingConfiguration = new IntermediateProcessingConfiguration();
    private Map<IntermediateProcessorStrategy, ILayoutProcessor> intermediateLayoutProcessorCache = new HashMap<IntermediateProcessorStrategy, ILayoutProcessor>();
    private List<ILayoutProcessor> algorithm = new LinkedList<ILayoutProcessor>();

    public TGraph doLayout(TGraph tgraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Tree layout", 1.0f);
        this.updateModules(tgraph);
        this.layout(tgraph, progressMonitor.subTask(1.0f));
        progressMonitor.done();
        return tgraph;
    }

    private void updateModules(TGraph graph) {
        if (this.dfsTreeifyer == null) {
            this.dfsTreeifyer = new DFSTreeifyer();
        }
        if (this.nodeOrderer == null) {
            this.nodeOrderer = new OrderBalance();
        }
        if (this.nodePlacer == null) {
            this.nodePlacer = new NodePlacer();
        }
        if (this.edgeRouter == null) {
            this.edgeRouter = new EdgeRouter();
        }
        this.intermediateProcessingConfiguration.clear();
        this.intermediateProcessingConfiguration.addAll(this.dfsTreeifyer.getIntermediateProcessingConfiguration(graph)).addAll(this.nodeOrderer.getIntermediateProcessingConfiguration(graph)).addAll(this.nodePlacer.getIntermediateProcessingConfiguration(graph)).addAll(this.edgeRouter.getIntermediateProcessingConfiguration(graph));
        this.algorithm.clear();
        this.algorithm.addAll(this.getIntermediateProcessorList(0));
        this.algorithm.add(this.dfsTreeifyer);
        this.algorithm.addAll(this.getIntermediateProcessorList(1));
        this.algorithm.add(this.nodeOrderer);
        this.algorithm.addAll(this.getIntermediateProcessorList(2));
        this.algorithm.add(this.nodePlacer);
        this.algorithm.addAll(this.getIntermediateProcessorList(3));
        this.algorithm.add(this.edgeRouter);
        this.algorithm.addAll(this.getIntermediateProcessorList(4));
    }

    private List<ILayoutProcessor> getIntermediateProcessorList(int slotIndex) {
        EnumSet<IntermediateProcessorStrategy> processors = this.intermediateProcessingConfiguration.getProcessors(slotIndex);
        ArrayList<ILayoutProcessor> result = new ArrayList<ILayoutProcessor>(processors.size());
        for (IntermediateProcessorStrategy processor : processors) {
            ILayoutProcessor processorImpl = this.intermediateLayoutProcessorCache.get((Object)processor);
            if (processorImpl == null) {
                processorImpl = processor.create();
                this.intermediateLayoutProcessorCache.put(processor, processorImpl);
            }
            result.add(processorImpl);
        }
        return result;
    }

    private void layout(TGraph graph, IElkProgressMonitor themonitor) {
        IElkProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Layout", (float)this.algorithm.size());
        if (((Boolean)graph.getProperty(MrTreeOptions.DEBUG_MODE)).booleanValue()) {
            System.out.println("KLay Tree uses the following " + this.algorithm.size() + " modules:");
            int i = 0;
            while (i < this.algorithm.size()) {
                System.out.println("   Slot " + String.format("%1$02d", i) + ": " + this.algorithm.get(i).getClass().getName());
                ++i;
            }
        }
        for (ILayoutProcessor processor : this.algorithm) {
            if (monitor.isCanceled()) {
                return;
            }
            processor.process(graph, monitor.subTask(1.0f));
        }
        monitor.done();
    }
}

