/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.elk.alg.mrtree.ILayoutProcessor;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NodePositionProcessor
implements ILayoutProcessor {
    private int numberOfNodes;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor set coordinates", 1.0f);
        this.numberOfNodes = tGraph.getNodes().isEmpty() ? 1 : tGraph.getNodes().size();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!((Boolean)tNode.getProperty(InternalProperties.ROOT)).booleanValue()) continue;
            root = tNode;
            KVector pos = tNode.getPosition();
            pos.x = ((Integer)tNode.getProperty(InternalProperties.XCOOR)).doubleValue();
            pos.y = 0.0;
        }
        this.setCoordinates(root.getChildrenCopy(), progressMonitor.subTask(1.0f));
        progressMonitor.done();
    }

    private void setCoordinates(LinkedList<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        if (!currentLevel.isEmpty()) {
            LinkedList<TNode> nextLevel = new LinkedList<TNode>();
            for (TNode tNode : currentLevel) {
                nextLevel.addAll(tNode.getChildrenCopy());
                KVector pos = tNode.getPosition();
                pos.x = ((Integer)tNode.getProperty(InternalProperties.XCOOR)).doubleValue();
                pos.y = ((Integer)tNode.getProperty(InternalProperties.YCOOR)).doubleValue();
            }
            this.setCoordinates(nextLevel, progressMonitor.subTask((float)(nextLevel.size() / this.numberOfNodes)));
        }
    }
}

