/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.elk.graph.text.ui.contentassist.AbstractElkGraphProposalProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ElkGraphProposalProvider
extends AbstractElkGraphProposalProvider {
    private static final Set<String> DISABLED_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"}", "]"}));
    @Inject
    private ElkGraphGrammarAccess grammar;
    @Inject
    private IImageHelper imageHelper;

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!DISABLED_KEYWORDS.contains(keyword.getValue()) && !Objects.equal((Object)keyword.getValue(), (Object)context.getPrefix())) {
            super.completeKeyword(keyword, context, acceptor);
        }
    }

    protected boolean doCreateStringProposals() {
        return false;
    }

    @Override
    public void complete_PropertyKey(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LayoutAlgorithmData _algorithm;
        boolean _matched = false;
        if (model instanceof ElkNode) {
            ElkNode _parent;
            boolean _tripleNotEquals;
            _matched = true;
            if (((ElkNode)model).getParent() == null || !((ElkNode)model).getChildren().isEmpty()) {
                _algorithm = this.getAlgorithm((ElkGraphElement)model);
                this.proposeProperties((ElkGraphElement)model, _algorithm, LayoutOptionData.Target.PARENTS, context, acceptor);
            }
            boolean bl = _tripleNotEquals = (_parent = ((ElkNode)model).getParent()) != null;
            if (_tripleNotEquals) {
                ElkNode _parent_1 = ((ElkNode)model).getParent();
                LayoutAlgorithmData _algorithm_1 = this.getAlgorithm((ElkGraphElement)_parent_1);
                this.proposeProperties((ElkGraphElement)model, _algorithm_1, LayoutOptionData.Target.NODES, context, acceptor);
            }
        }
        if (!_matched && model instanceof ElkEdge) {
            _matched = true;
            _algorithm = this.getAlgorithm((ElkGraphElement)model);
            this.proposeProperties((ElkGraphElement)model, _algorithm, LayoutOptionData.Target.EDGES, context, acceptor);
        }
        if (!_matched && model instanceof ElkPort) {
            _matched = true;
            _algorithm = this.getAlgorithm((ElkGraphElement)model);
            this.proposeProperties((ElkGraphElement)model, _algorithm, LayoutOptionData.Target.PORTS, context, acceptor);
        }
        if (!_matched && model instanceof ElkLabel) {
            _matched = true;
            _algorithm = this.getAlgorithm((ElkGraphElement)model);
            this.proposeProperties((ElkGraphElement)model, _algorithm, LayoutOptionData.Target.LABELS, context, acceptor);
        }
    }

    private LayoutAlgorithmData getAlgorithm(ElkGraphElement element) {
        ElkNode node = (ElkNode)EcoreUtil2.getContainerOfType((EObject)element, ElkNode.class);
        if (node != null) {
            boolean _not;
            String algorithmId = (String)node.getProperty(CoreOptions.ALGORITHM);
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)algorithmId);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                LayoutMetaDataService _instance = LayoutMetaDataService.getInstance();
                return _instance.getAlgorithmDataBySuffix(algorithmId);
            }
        }
        return null;
    }

    private void proposeProperties(final ElkGraphElement element, final LayoutAlgorithmData algorithmData, final LayoutOptionData.Target targetType, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        Collection _optionData = metaDataService.getOptionData();
        Functions.Function1<LayoutOptionData, Boolean> _function = new Functions.Function1<LayoutOptionData, Boolean>(){

            public Boolean apply(LayoutOptionData o) {
                return targetType == null || o.getTargets().contains(targetType);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_optionData, (Functions.Function1)_function);
        Functions.Function1<LayoutOptionData, Boolean> _function_1 = new Functions.Function1<LayoutOptionData, Boolean>(){

            public Boolean apply(LayoutOptionData o) {
                return algorithmData == null || algorithmData.knowsOption(o) || Objects.equal((Object)CoreOptions.ALGORITHM, (Object)o);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1<LayoutOptionData, Boolean> _function_2 = new Functions.Function1<LayoutOptionData, Boolean>(){

            public Boolean apply(LayoutOptionData o) {
                return element == null || !element.getProperties().map().containsKey(o);
            }
        };
        Iterable filteredOptions = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
        for (LayoutOptionData option : filteredOptions) {
            String _id = option.getId();
            String[] split = _id.split("\\.");
            String suffix = null;
            boolean foundMatch = false;
            int _length = split.length;
            int i = _length - 1;
            while (i >= 0 && !foundMatch) {
                if (suffix == null) {
                    String _get;
                    int _minusMinus = i--;
                    suffix = _get = split[_minusMinus];
                } else {
                    String _plus_1;
                    int _minusMinus_1 = i--;
                    String _get_1 = split[_minusMinus_1];
                    String _plus = String.valueOf(_get_1) + ".";
                    suffix = _plus_1 = String.valueOf(_plus) + suffix;
                }
                if (metaDataService.getOptionDataBySuffix(suffix) == null || !suffix.startsWith(context.getPrefix())) continue;
                foundMatch = true;
            }
            StyledString _displayString = this.getDisplayString((ILayoutMetaData)option, suffix);
            Image _image = this.getImage(option, null);
            ICompletionProposal proposal = this.createCompletionProposal(suffix, _displayString, _image, context);
            acceptor.accept(proposal);
        }
    }

    @Override
    public void completeProperty_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IProperty property;
        if (model instanceof ElkPropertyToValueMapEntryImpl && (property = ((ElkPropertyToValueMapEntryImpl)model).getKey()) instanceof LayoutOptionData) {
            String[] _choices;
            String[] stringArray = _choices = ((LayoutOptionData)property).getChoices();
            int n = _choices.length;
            int n2 = 0;
            while (n2 < n) {
                String choice = stringArray[n2];
                Image _image = this.getImage((LayoutOptionData)property, choice);
                ICompletionProposal proposal = this.createCompletionProposal(choice, choice, _image, context);
                acceptor.accept(proposal);
                ++n2;
            }
            boolean _equals = Objects.equal((Object)CoreOptions.ALGORITHM, (Object)property);
            if (_equals) {
                this.proposeAlgorithms(context, acceptor);
            }
        }
    }

    private void proposeAlgorithms(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        Collection _algorithmData = metaDataService.getAlgorithmData();
        for (LayoutAlgorithmData algorithm : _algorithmData) {
            String _id = algorithm.getId();
            String[] split = _id.split("\\.");
            String suffix = null;
            boolean foundMatch = false;
            int _length = split.length;
            int i = _length - 1;
            while (i >= 0 && !foundMatch) {
                if (suffix == null) {
                    String _get;
                    int _minusMinus = i--;
                    suffix = _get = split[_minusMinus];
                } else {
                    String _plus_1;
                    int _minusMinus_1 = i--;
                    String _get_1 = split[_minusMinus_1];
                    String _plus = String.valueOf(_get_1) + ".";
                    suffix = _plus_1 = String.valueOf(_plus) + suffix;
                }
                if (metaDataService.getAlgorithmDataBySuffix(suffix) == null || !suffix.startsWith(context.getPrefix())) continue;
                foundMatch = true;
            }
            StyledString _displayString = this.getDisplayString((ILayoutMetaData)algorithm, suffix);
            ICompletionProposal proposal = this.createCompletionProposal(suffix, _displayString, null, context);
            acceptor.accept(proposal);
        }
    }

    private StyledString getDisplayString(ILayoutMetaData data, String suffix) {
        StyledString _styledString = new StyledString(suffix);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)" ");
        _builder.append((Object)"\u2013", " ");
        _builder.append((Object)" ");
        String _name = data.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" (");
        String _id = data.getId();
        _builder.append((Object)_id, " ");
        _builder.append((Object)")");
        StyledString _styledString_1 = new StyledString(_builder.toString(), StyledString.QUALIFIER_STYLER);
        return this.operator_plus(_styledString, _styledString_1);
    }

    protected Image getImage(EObject eObject) {
        if (eObject instanceof Keyword) {
            String key;
            ElkGraphGrammarAccess.ElkLabelElements _elkLabelAccess;
            Keyword _labelKeyword_0;
            ElkGraphGrammarAccess.ElkPortElements _elkPortAccess;
            Keyword _portKeyword_0;
            ElkGraphGrammarAccess.ElkEdgeElements _elkEdgeAccess;
            Keyword _edgeKeyword_0;
            ElkGraphGrammarAccess.ElkNodeElements _elkNodeAccess;
            Keyword _nodeKeyword_0;
            String _switchResult = null;
            boolean _matched = false;
            ElkGraphGrammarAccess.RootNodeElements _rootNodeAccess = this.grammar.getRootNodeAccess();
            Keyword _graphKeyword_1_0 = _rootNodeAccess.getGraphKeyword_1_0();
            if (Objects.equal((Object)eObject, (Object)_graphKeyword_1_0)) {
                _matched = true;
                _switchResult = "elkgraph";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_nodeKeyword_0 = (_elkNodeAccess = this.grammar.getElkNodeAccess()).getNodeKeyword_0()))) {
                _matched = true;
                _switchResult = "elknode";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_edgeKeyword_0 = (_elkEdgeAccess = this.grammar.getElkEdgeAccess()).getEdgeKeyword_0()))) {
                _matched = true;
                _switchResult = "elkedge";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_portKeyword_0 = (_elkPortAccess = this.grammar.getElkPortAccess()).getPortKeyword_0()))) {
                _matched = true;
                _switchResult = "elkport";
            }
            if (!_matched && Objects.equal((Object)eObject, (Object)(_labelKeyword_0 = (_elkLabelAccess = this.grammar.getElkLabelAccess()).getLabelKeyword_0()))) {
                _matched = true;
                _switchResult = "elklabel";
            }
            if ((key = _switchResult) != null) {
                return this.imageHelper.getImage(String.valueOf(key) + ".gif");
            }
        }
        return super.getImage(eObject);
    }

    private Image getImage(LayoutOptionData option, String value) {
        String _switchResult = null;
        LayoutOptionData.Type _type = option.getType();
        if (_type != null) {
            switch (_type) {
                case BOOLEAN: {
                    String _xifexpression = null;
                    boolean _equals = Objects.equal((Object)value, (Object)"false");
                    _xifexpression = _equals ? "prop_false" : "prop_true";
                    _switchResult = _xifexpression;
                    break;
                }
                case INT: {
                    _switchResult = "prop_int";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "prop_double";
                    break;
                }
                case ENUM: 
                case ENUMSET: {
                    _switchResult = "prop_choice";
                    break;
                }
                default: {
                    _switchResult = "prop_text";
                    break;
                }
            }
        } else {
            _switchResult = "prop_text";
        }
        String key = _switchResult;
        return this.imageHelper.getImage(String.valueOf(key) + ".gif");
    }

    private StyledString operator_plus(StyledString s1, StyledString s2) {
        return s1.append(s2);
    }
}

