/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.elk.alg.mrtree.ILayoutProcessor;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NeighborsProcessor
implements ILayoutProcessor {
    private int numberOfNodes;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor set neighbors", 1.0f);
        this.numberOfNodes = tGraph.getNodes().isEmpty() ? 1 : tGraph.getNodes().size();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!((Boolean)tNode.getProperty(InternalProperties.ROOT)).booleanValue()) continue;
            root = tNode;
        }
        if (root != null) {
            this.setNeighbors(root.getChildren(), progressMonitor);
        }
        progressMonitor.done();
    }

    private void setNeighbors(Iterable<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        if (!Iterables.isEmpty(currentLevel)) {
            IElkProgressMonitor sT = progressMonitor.subTask((float)(Iterables.size(currentLevel) / this.numberOfNodes));
            sT.begin("Set neighbors in level", 1.0f);
            Iterable<TNode> nextLevel = new Iterable<TNode>(){

                @Override
                public Iterator<TNode> iterator() {
                    return Iterators.emptyIterator();
                }
            };
            TNode lN = null;
            for (TNode cN : currentLevel) {
                nextLevel = Iterables.concat((Iterable)nextLevel, cN.getChildren());
                if (lN != null) {
                    lN.setProperty(InternalProperties.RIGHTNEIGHBOR, (Object)cN);
                    cN.setProperty(InternalProperties.LEFTNEIGHBOR, (Object)lN);
                    if (cN.getParent() == lN.getParent()) {
                        lN.setProperty(InternalProperties.RIGHTSIBLING, (Object)cN);
                        cN.setProperty(InternalProperties.LEFTSIBLING, (Object)lN);
                    }
                }
                lN = cN;
            }
            sT.done();
            this.setNeighbors(nextLevel, progressMonitor);
        }
    }
}

