/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.conversion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyKeyValueConverter
extends AbstractValueConverter<IProperty<?>> {
    private IDValueConverter idValueConverter;

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, final ElkGraphGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1<IDValueConverter> _function = new Procedures.Procedure1<IDValueConverter>(){

            public void apply(IDValueConverter it) {
                TerminalRule _iDRule = grammarAccess.getIDRule();
                it.setRule((AbstractRule)_iDRule);
            }
        };
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    public String toString(IProperty<?> value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("IProperty value may not be null.", null, null);
        }
        String _id = value.getId();
        List _split = Strings.split((String)_id, (String)".");
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return PropertyKeyValueConverter.this.idValueConverter.toString((Object)it);
            }
        };
        List _map = ListExtensions.map((List)_split, (Functions.Function1)_function);
        return IterableExtensions.join((Iterable)_map, (CharSequence)".");
    }

    public IProperty<?> toValue(String string, final INode node) throws ValueConverterException {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Cannot convert empty string to a property idenfifier.", node, null);
        }
        List _split = Strings.split((String)string, (String)".");
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return PropertyKeyValueConverter.this.idValueConverter.toValue(it, node);
            }
        };
        List _map = ListExtensions.map((List)_split, (Functions.Function1)_function);
        String idSuffix = IterableExtensions.join((Iterable)_map, (CharSequence)".");
        LayoutMetaDataService _instance = LayoutMetaDataService.getInstance();
        LayoutOptionData optionData = _instance.getOptionDataBySuffix(idSuffix);
        if (optionData == null) {
            throw new ValueConverterException("No layout option with identifier '" + idSuffix + "' can be found.", node, null);
        }
        return optionData;
    }
}

