/**
 * Copyright (c) 2016 Kiel University and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Kiel University - initial API and implementation
 */
package org.eclipse.elk.alg.force.options;

import org.eclipse.elk.alg.force.options.StressMetaDataProvider;
import org.eclipse.elk.alg.force.stress.StressLayoutProvider;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.properties.IProperty;

@SuppressWarnings("all")
public class StressOptions implements ILayoutMetaDataProvider {
  /**
   * The id of the ELK Stress algorithm.
   */
  public final static String ALGORITHM_ID = "org.eclipse.elk.stress";
  
  /**
   * Whether the algorithm should be run in interactive mode for the content of a parent node.
   * What this means exactly depends on how the specific algorithm interprets this option.
   * Usually in the interactive mode algorithms try to modify the current layout as little as
   * possible.
   */
  public final static IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
  
  /**
   * Prevent that the node is moved by the layout algorithm.
   */
  public final static IProperty<Boolean> FIXED = StressMetaDataProvider.FIXED;
  
  /**
   * Dimensions that are permitted to be altered during layout.
   */
  public final static IProperty<StressMajorization.Dimension> DIMENSION = StressMetaDataProvider.DIMENSION;
  
  /**
   * Termination criterion for the iterative process.
   */
  public final static IProperty<Double> EPSILON = StressMetaDataProvider.EPSILON;
  
  /**
   * Maximum number of performed iterations. Takes higher
   * precedence than 'epsilon'.
   */
  public final static IProperty<Integer> ITERATION_LIMIT = StressMetaDataProvider.ITERATION_LIMIT;
  
  /**
   * Either specified for parent nodes or for individual edges,
   * where the latter takes higher precedence.
   */
  public final static IProperty<Double> DESIRED_EDGE_LENGTH = StressMetaDataProvider.DESIRED_EDGE_LENGTH;
  
  /**
   * Layouter-specific algorithm factory.
   */
  public static class StressFactory implements org.eclipse.elk.core.util.IFactory<AbstractLayoutProvider> {
    public AbstractLayoutProvider create() {
      AbstractLayoutProvider provider = new StressLayoutProvider();
      provider.initialize("");
      return provider;
    }
    
    public void destroy(final AbstractLayoutProvider obj) {
      obj.dispose();
    }
  }
  
  public void apply(final org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry registry) {
    registry.register(new LayoutAlgorithmData.Builder()
        .id("org.eclipse.elk.stress")
        .name("ELK Stress")
        .description("Minimizes the stress within a layout using stress majorization. Stress exists if the euclidean distance between a pair of nodes doesn\'t match their graph theoretic distance, that is, the shortest path between the two nodes. The method allows to specify individual edge lengths.")
        .providerFactory(new StressFactory())
        .category("org.eclipse.elk.force")
        .melkBundleName(null)
        .definingBundleId("org.eclipse.elk.alg.force")
        .imagePath("images/stress_layout.png")
        .create()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.interactive",
        INTERACTIVE.getDefault()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.stress.fixed",
        FIXED.getDefault()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.stress.dimension",
        DIMENSION.getDefault()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.stress.epsilon",
        EPSILON.getDefault()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.stress.iterationLimit",
        ITERATION_LIMIT.getDefault()
    );
    registry.addOptionSupport(
        "org.eclipse.elk.stress",
        "org.eclipse.elk.stress.desiredEdgeLength",
        DESIRED_EDGE_LENGTH.getDefault()
    );
  }
}
