/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.options;

import org.eclipse.elk.alg.force.options.StressMetaDataProvider;
import org.eclipse.elk.alg.force.stress.StressLayoutProvider;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;

public class StressOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.stress";
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<Boolean> FIXED = StressMetaDataProvider.FIXED;
    public static final IProperty<StressMajorization.Dimension> DIMENSION = StressMetaDataProvider.DIMENSION;
    public static final IProperty<Double> EPSILON = StressMetaDataProvider.EPSILON;
    public static final IProperty<Integer> ITERATION_LIMIT = StressMetaDataProvider.ITERATION_LIMIT;
    public static final IProperty<Double> DESIRED_EDGE_LENGTH = StressMetaDataProvider.DESIRED_EDGE_LENGTH;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Stress").description("Minimizes the stress within a layout using stress majorization. Stress exists if the euclidean distance between a pair of nodes doesn't match their graph theoretic distance, that is, the shortest path between the two nodes. The method allows to specify individual edge lengths.").providerFactory((IFactory)new StressFactory()).category("org.eclipse.elk.force").melkBundleName(null).definingBundleId("org.eclipse.elk.alg.force").imagePath("images/stress_layout.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.stress.fixed", FIXED.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.stress.dimension", DIMENSION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.stress.epsilon", EPSILON.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.stress.iterationLimit", ITERATION_LIMIT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.stress.desiredEdgeLength", DESIRED_EDGE_LENGTH.getDefault());
    }

    public static class StressFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            StressLayoutProvider provider = new StressLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

