/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.controls;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class AbstractFilteredReferenceCommand<T extends EStructuralFeature>
extends ChangeCommand {
    private final Shell shell;
    private final ComposedAdapterFactory composedAdapterFactory;
    private final EClass rootClass;
    private final ECPSelectionStatusValidator validator;
    private final boolean allowMultiReferences;

    public AbstractFilteredReferenceCommand(Notifier notifier, ComposedAdapterFactory composedAdapterFactory, Shell shell, EClass rootClass, ECPSelectionStatusValidator validator, boolean allowMultiReferences) {
        super(notifier);
        this.shell = shell;
        this.composedAdapterFactory = composedAdapterFactory;
        this.rootClass = rootClass;
        this.validator = validator;
        this.allowMultiReferences = allowMultiReferences;
    }

    private Class<?> returnedClass() {
        ParameterizedType parameterizedType = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    protected void doExecute() {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        ECPViewEditorTreeSelectionDialog dialog = new ECPViewEditorTreeSelectionDialog(this.shell, (ILabelProvider)labelProvider, this.getContentProvider(this.rootClass));
        this.validator.setECPViewEditorTreeSelectionDialog(dialog);
        dialog.setAllowMultiple(false);
        dialog.setValidator(this.validator);
        dialog.setInput(this.rootClass != null ? this.rootClass : EPackage.Registry.INSTANCE);
        dialog.setMessage("Select a " + this.returnedClass().getSimpleName());
        dialog.setTitle("Select a " + this.returnedClass().getSimpleName());
        int result = dialog.open();
        if (result == 0) {
            Object selection = dialog.getFirstResult();
            if (this.returnedClass().isInstance(selection)) {
                EStructuralFeature selectedFeature = (EStructuralFeature)selection;
                ArrayList<EReference> bottomUpPath = new ArrayList<EReference>();
                TreePath path = dialog.getTreePath();
                int i = 0;
                while (i < path.getSegmentCount() - 1) {
                    Object o = path.getSegment(i);
                    if (EReference.class.isInstance(o)) {
                        bottomUpPath.add((EReference)o);
                    }
                    ++i;
                }
                this.setSelectedValues(selectedFeature, bottomUpPath);
            }
        }
        labelProvider.dispose();
    }

    protected abstract void setSelectedValues(T var1, List<EReference> var2);

    private ITreeContentProvider getContentProvider(EClass rootClass) {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (EPackage.class.isInstance(element)) {
                    return true;
                }
                if (EClass.class.isInstance(element)) {
                    boolean hasAttributes;
                    EClass eClass = (EClass)element;
                    boolean hasReferences = !eClass.getEAllReferences().isEmpty();
                    boolean bl = hasAttributes = !eClass.getEAllAttributes().isEmpty();
                    return hasReferences || hasAttributes;
                }
                if (EReference.class.isInstance(element)) {
                    EReference eReference = (EReference)element;
                    return eReference.isMany() && !AbstractFilteredReferenceCommand.this.allowMultiReferences ? false : this.hasChildren(eReference.getEReferenceType());
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (EClass.class.isInstance(parentElement)) {
                    EClass eClass = (EClass)parentElement;
                    Set<Object> result = this.getElementsForEClass(eClass);
                    return result.toArray();
                }
                if (EReference.class.isInstance(parentElement)) {
                    EReference eReference = (EReference)parentElement;
                    Set<Object> result = this.getElementsForEClass(eReference.getEReferenceType());
                    return result.toArray();
                }
                if (EPackage.Registry.class.isInstance(parentElement)) {
                    return ((EPackage.Registry)EPackage.Registry.class.cast(parentElement)).values().toArray();
                }
                if (EPackage.class.isInstance(parentElement)) {
                    LinkedHashSet children = new LinkedHashSet();
                    children.addAll(((EPackage)EPackage.class.cast(parentElement)).getESubpackages());
                    children.addAll(((EPackage)EPackage.class.cast(parentElement)).getEClassifiers());
                    return children.toArray();
                }
                return null;
            }

            private Set<Object> getElementsForEClass(EClass eClass) {
                LinkedHashSet<Object> result = new LinkedHashSet<Object>();
                if (eClass.isAbstract() || eClass.isInterface()) {
                    for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
                        if (eClass == eClassifier || !EClass.class.isInstance(eClassifier) || !eClass.isSuperTypeOf((EClass)eClassifier)) continue;
                        result.add(eClassifier);
                    }
                } else {
                    result.addAll((Collection<Object>)eClass.getEAllReferences());
                    result.addAll((Collection<Object>)eClass.getEAllAttributes());
                }
                return result;
            }
        };
    }

    protected static abstract class ECPSelectionStatusValidator
    implements ISelectionStatusValidator {
        private ECPViewEditorTreeSelectionDialog dialog;

        protected ECPSelectionStatusValidator() {
        }

        private void setECPViewEditorTreeSelectionDialog(ECPViewEditorTreeSelectionDialog dialog) {
            this.dialog = dialog;
        }

        protected TreePath getTreePath() {
            return this.dialog.getTreePath();
        }
    }

    private static class ECPViewEditorTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        private TreePath treePath;

        public ECPViewEditorTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        public TreePath getTreePath() {
            TreeSelection selection;
            if (this.getTreeViewer() != null && !(selection = (TreeSelection)this.getTreeViewer().getSelection()).isEmpty()) {
                this.treePath = selection.getPaths()[0];
            }
            return this.treePath;
        }
    }
}

