/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.stack.ui.swt;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;

public class StackItemViewService
implements ViewModelService {
    private ModelChangeListener domainListener;
    private ViewModelContext context;
    private VElement viewModel;
    private EObject domain;
    private Map<EObject, Map<EStructuralFeature, Set<VStackLayout>>> registry;
    private Set<StackItemDomainModelReferenceChangeListener> changeListener;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.viewModel = context.getViewModel();
        this.domain = context.getDomainModel();
        this.registry = new LinkedHashMap<EObject, Map<EStructuralFeature, Set<VStackLayout>>>();
        this.changeListener = new LinkedHashSet<StackItemDomainModelReferenceChangeListener>();
        this.initRegistry(this.viewModel);
        this.evaluateRegistry();
        this.domainListener = this.createDomainListener();
        context.registerDomainChangeListener(this.domainListener);
    }

    private void initRegistry(VElement viewModel) {
        LinkedHashSet<VStackLayout> stacks = new LinkedHashSet<VStackLayout>();
        TreeIterator iterator = viewModel.eAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            if (!VStackLayout.class.isInstance(current)) continue;
            stacks.add((VStackLayout)VStackLayout.class.cast(current));
        }
        for (VStackLayout stack : stacks) {
            VDomainModelReference dmr = stack.getDomainModelReference();
            if (dmr == null) continue;
            dmr.init(this.domain);
            EStructuralFeature.Setting setting = this.addToRegistry(stack, dmr);
            if (setting == null) {
                return;
            }
            dmr.getChangeListener().add((Object)this.createDMRChangeListener(stack, setting));
            this.context.registerDomainChangeListener((ModelChangeListener)dmr);
        }
    }

    private EStructuralFeature.Setting addToRegistry(VStackLayout stack, VDomainModelReference dmr) {
        EStructuralFeature.Setting firstSetting = null;
        Iterator settings = dmr.getIterator();
        if (settings.hasNext()) {
            firstSetting = (EStructuralFeature.Setting)settings.next();
        }
        if (firstSetting == null) {
            return null;
        }
        this.addToRegistry(firstSetting.getEObject(), firstSetting.getEStructuralFeature(), stack);
        return firstSetting;
    }

    private void addToRegistry(EObject object, EStructuralFeature domainModelEFeature, VStackLayout stack) {
        Map<EStructuralFeature, Set<VStackLayout>> featureToLayoutMap;
        if (!this.registry.containsKey(object)) {
            this.registry.put(object, new LinkedHashMap());
        }
        if (!(featureToLayoutMap = this.registry.get(object)).containsKey(domainModelEFeature)) {
            featureToLayoutMap.put(domainModelEFeature, new LinkedHashSet());
        }
        featureToLayoutMap.get(domainModelEFeature).add(stack);
    }

    private boolean doesRegistryContain(EObject object, EStructuralFeature domainModelEFeature) {
        if (!this.registry.containsKey(object)) {
            return false;
        }
        Map<EStructuralFeature, Set<VStackLayout>> featureToStackMap = this.registry.get(object);
        return featureToStackMap.containsKey(domainModelEFeature);
    }

    private void evaluateRegistry() {
        for (EObject object : this.registry.keySet()) {
            Map<EStructuralFeature, Set<VStackLayout>> featureToStacksMap = this.registry.get(object);
            for (EStructuralFeature feature : featureToStacksMap.keySet()) {
                this.evaluate(object, feature);
            }
        }
    }

    private void evaluate(EObject object, EStructuralFeature domainModelEFeature) {
        Object currentValue = object.eGet(domainModelEFeature);
        Set<VStackLayout> stacks = this.registry.get(object).get(domainModelEFeature);
        for (VStackLayout stack : stacks) {
            boolean topElementSet = false;
            for (VStackItem item : stack.getStackItems()) {
                if (currentValue == null) {
                    if (currentValue != item.getValue()) continue;
                    stack.setTopElement(item);
                    topElementSet = true;
                    break;
                }
                if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)domainModelEFeature.getEType()) && item.getValue().equals(((Enumerator)Enumerator.class.cast(currentValue)).getLiteral())) {
                    stack.setTopElement(item);
                    topElementSet = true;
                    break;
                }
                if (!currentValue.equals(item.getValue())) continue;
                stack.setTopElement(item);
                topElementSet = true;
                break;
            }
            if (topElementSet) continue;
            stack.setTopElement(null);
        }
    }

    private ModelChangeListener createDomainListener() {
        return new StackDomainChangeListener();
    }

    private DomainModelReferenceChangeListener createDMRChangeListener(VStackLayout stack, EStructuralFeature.Setting oldSetting) {
        StackItemDomainModelReferenceChangeListener listener = new StackItemDomainModelReferenceChangeListener(stack, oldSetting);
        this.changeListener.add(listener);
        return listener;
    }

    public void dispose() {
        this.viewModel = null;
        this.domain = null;
        this.registry.clear();
        this.registry = null;
        for (StackItemDomainModelReferenceChangeListener listener : this.changeListener) {
            listener.dispose();
        }
        this.changeListener.clear();
        this.changeListener = null;
        this.context.unregisterDomainChangeListener(this.domainListener);
        this.domainListener = null;
        this.context = null;
    }

    public int getPriority() {
        return 7;
    }

    private class StackDomainChangeListener
    implements ModelChangeListener {
        private StackDomainChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            EStructuralFeature feature;
            EObject notifier = notification.getNotifier();
            if (!StackItemViewService.this.doesRegistryContain(notifier, feature = notification.getStructuralFeature())) {
                return;
            }
            StackItemViewService.this.evaluate(notifier, feature);
        }
    }

    private class StackItemDomainModelReferenceChangeListener
    implements DomainModelReferenceChangeListener {
        private EStructuralFeature.Setting setting;
        private final VStackLayout stack;

        public StackItemDomainModelReferenceChangeListener(VStackLayout stack, EStructuralFeature.Setting oldSetting) {
            this.stack = stack;
            this.setting = oldSetting;
        }

        public void notifyChange() {
            this.removeOutdatedEntriesFromRegistry();
            this.addCurrentEntriesToRegistry();
            StackItemViewService.this.evaluate(this.setting.getEObject(), this.setting.getEStructuralFeature());
        }

        private void removeOutdatedEntriesFromRegistry() {
            Map featureToStackMap = (Map)StackItemViewService.this.registry.get(this.setting.getEObject());
            Set stacks = (Set)featureToStackMap.get(this.setting.getEStructuralFeature());
            stacks.remove(this.stack);
            if (!stacks.isEmpty()) {
                return;
            }
            featureToStackMap.remove(this.setting.getEStructuralFeature());
            if (!featureToStackMap.isEmpty()) {
                return;
            }
            StackItemViewService.this.registry.remove(this.setting.getEObject());
        }

        private void addCurrentEntriesToRegistry() {
            this.setting = StackItemViewService.this.addToRegistry(this.stack, this.stack.getDomainModelReference());
        }

        public void dispose() {
            this.stack.getDomainModelReference().getChangeListener().remove((Object)this);
            StackItemViewService.this.context.unregisterDomainChangeListener((ModelChangeListener)this.stack.getDomainModelReference());
        }
    }
}

