/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.transaction;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreCommandNotifier;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.internal.client.model.util.AbstractEMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.transaction.AbstractEMFStoreTransactionalCommandStackImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class EMFStoreTransactionalCommandStack
extends AbstractEMFStoreTransactionalCommandStackImpl
implements EMFStoreCommandStack {
    private Command currentCommand;
    private final EMFStoreCommandNotifier notifier = new EMFStoreCommandNotifier();

    public void execute(Command command) {
        if (command instanceof AbstractEMFStoreCommand) {
            this.runEMFStoreCommand((AbstractEMFStoreCommand)command);
            return;
        }
        super.execute(command);
    }

    private void runEMFStoreCommand(final AbstractEMFStoreCommand cmd) {
        RecordingCommand recordingCommand = new RecordingCommand((TransactionalEditingDomain)ESWorkspaceProviderImpl.getInstance().getEditingDomain()){

            protected void doExecute() {
                cmd.execute();
            }
        };
        super.execute((Command)recordingCommand);
        if (!cmd.shouldIgnoreExceptions() && cmd.getRuntimeException() != null) {
            throw cmd.getRuntimeException();
        }
    }

    protected void basicRedo() {
        this.notifier.notifiyListenersAboutStart(this.mostRecentCommand);
        this.redoOfBasicCommandStack();
        this.rethrowComamndInCaseOfError(this.mostRecentCommand);
        this.notifier.notifiyListenersAboutCommandCompleted(this.mostRecentCommand);
    }

    protected void basicUndo() {
        this.notifier.notifiyListenersAboutStart(this.mostRecentCommand);
        this.undoOfBasicCommandStack();
        this.rethrowComamndInCaseOfError(this.mostRecentCommand);
        this.notifier.notifiyListenersAboutCommandCompleted(this.mostRecentCommand);
    }

    /*
     * Unable to fully structure code
     */
    private void redoOfBasicCommandStack() {
        block3: {
            command = (Command)this.commandList.get(++this.top);
            try {
                command.redo();
                this.mostRecentCommand = command;
                break block3;
            }
            catch (RuntimeException exception) {
                this.handleError(exception);
                this.mostRecentCommand = null;
                commands = this.commandList.listIterator(this.top--);
                ** while (commands.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                otherCommand = (Command)commands.next();
                otherCommand.dispose();
                commands.remove();
                continue;
            }
        }
        this.notifyListeners();
    }

    private void undoOfBasicCommandStack() {
        Command command = (Command)this.commandList.get(this.top--);
        try {
            command.undo();
            this.mostRecentCommand = command;
        }
        catch (RuntimeException exception) {
            this.handleError(exception);
            this.mostRecentCommand = null;
            this.flush();
        }
        this.notifyListeners();
    }

    private void rethrowComamndInCaseOfError(Command command) {
        AbstractEMFStoreCommand emfStoreCmd;
        if (command instanceof AbstractEMFStoreCommand && !(emfStoreCmd = (AbstractEMFStoreCommand)command).shouldIgnoreExceptions() && emfStoreCmd.getRuntimeException() != null) {
            throw emfStoreCmd.getRuntimeException();
        }
    }

    protected void basicExecute(Command command) {
        if (this.currentCommand == null) {
            this.currentCommand = command;
            this.notifier.notifiyListenersAboutStart(command);
        }
        try {
            super.basicExecute(command);
        }
        catch (OperationCanceledException e) {
            this.notifier.notifiyListenersAboutCommandFailed(command, (Exception)((Object)e));
            this.currentCommand = null;
            throw e;
        }
        if (this.currentCommand == command) {
            if (this.mostRecentCommand == command) {
                this.notifier.notifiyListenersAboutCommandCompleted(command);
            }
            this.currentCommand = null;
        }
    }

    protected void handleRollback(Command command, RollbackException rbe) {
        super.handleRollback(command, rbe);
        Object exception = null;
        if (rbe != null) {
            exception = rbe.getCause() != null && rbe.getCause() instanceof Exception ? (Exception)rbe.getCause() : rbe;
        }
        this.notifier.notifiyListenersAboutCommandFailed(command, (Exception)exception);
        if (this.currentCommand == command) {
            this.currentCommand = null;
        }
    }

    public void addCommandStackObserver(CommandObserver observer) {
        this.notifier.addCommandStackObserver(observer);
    }

    public void removeCommandStackObserver(CommandObserver observer) {
        this.notifier.removeCommandStackObserver(observer);
    }
}

