/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.observer.ESCheckoutObserver;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.observer.ESShareObserver;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.client.observer.ESWorkspaceInitObserver;
import org.eclipse.emf.emfstore.client.provider.ESEditingDomainProvider;
import org.eclipse.emf.emfstore.client.sessionprovider.ESAbstractSessionProvider;
import org.eclipse.emf.emfstore.client.util.ESClientURIUtil;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreBasicCommandStack;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.SessionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcAdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.provider.ClientXMIResourceSetProvider;
import org.eclipse.emf.emfstore.internal.client.startup.ClientHrefMigrator;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverBus;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrator;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigratorUtil;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ESWorkspaceProviderImpl
implements ESWorkspaceProvider,
ESCommitObserver,
ESUpdateObserver,
ESShareObserver,
ESCheckoutObserver,
ESDisposable {
    private static ESWorkspaceProviderImpl instance;
    private AdminConnectionManager adminConnectionManager;
    private ConnectionManager connectionManager;
    private EditingDomain editingDomain;
    private ObserverBus observerBus;
    private ResourceSet resourceSet;
    private SessionManager sessionManager;
    private Workspace currentWorkspace;

    public static synchronized ESWorkspaceProviderImpl getInstance() {
        if (instance == null) {
            try {
                instance = new ESWorkspaceProviderImpl();
                instance.initialize();
            }
            catch (RuntimeException e) {
                ModelUtil.logException((String)"Workspace Initialization failed, shutting down", (Throwable)e);
                throw e;
            }
            CommonUtil.getAllModelElementEClasses();
            instance.notifyPostWorkspaceInitiators();
        }
        return instance;
    }

    public static synchronized void init() {
        ESWorkspaceProviderImpl.getInstance();
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            ESWorkspaceProviderImpl.getInstance();
        }
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    private ESWorkspaceProviderImpl() {
    }

    public void dispose() {
        if (this.currentWorkspace != null) {
            RunESCommand.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ((WorkspaceImpl)ESWorkspaceProviderImpl.this.currentWorkspace).dispose();
                    return null;
                }
            });
            this.currentWorkspace = null;
        }
    }

    public boolean isDisposed() {
        return this.currentWorkspace == null;
    }

    public void load() {
        Workspace workspace;
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.resourceSetProvider", true, (Comparator)new ESPriorityComparator("priority", true));
        ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
        this.resourceSet = resourceSetProvider.getResourceSet();
        this.setEditingDomain(this.createEditingDomain(this.resourceSet));
        URI workspaceURI = ESClientURIUtil.createWorkspaceURI();
        if (!this.resourceSet.getURIConverter().exists(workspaceURI, null)) {
            workspace = this.createNewWorkspace(this.resourceSet, workspaceURI);
        } else {
            if (resourceSetProvider instanceof ClientXMIResourceSetProvider && !new ClientHrefMigrator().migrate()) {
                throw new RuntimeException("Migration failed");
            }
            this.migrateModelIfNeeded(this.resourceSet);
            Resource resource = this.resourceSet.createResource(workspaceURI);
            try {
                resource.load(ModelUtil.getResourceLoadOptions());
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Error while loading workspace.", e);
            }
            EList directContents = resource.getContents();
            workspace = (Workspace)directContents.get(0);
        }
        workspace.setResourceSet(this.resourceSet);
        new EMFStoreCommand(){

            protected void doRun() {
                workspace.init();
            }
        }.run(true);
        this.currentWorkspace = workspace;
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this);
    }

    public void flushCommandStack() {
        this.getEditingDomain().getCommandStack().flush();
    }

    public void migrate(String absoluteFilename) {
    }

    public AdminConnectionManager getAdminConnectionManager() {
        return this.adminConnectionManager;
    }

    public static ProjectSpace getProjectSpace(EObject modelElement) {
        if (modelElement == null) {
            throw new IllegalArgumentException("The model element is null");
        }
        if (modelElement instanceof ProjectSpace) {
            return (ProjectSpace)modelElement;
        }
        Project project = ModelUtil.getProject((EObject)modelElement);
        if (project == null) {
            throw new IllegalArgumentException("The model element " + modelElement + " has no project");
        }
        return ESWorkspaceProviderImpl.getProjectSpace(project);
    }

    public static ProjectSpace getProjectSpace(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("The project is null");
        }
        if (ModelPackage.eINSTANCE.getProjectSpace().isInstance((Object)project.eContainer())) {
            return (ProjectSpace)project.eContainer();
        }
        throw new IllegalStateException("Project is not contained by any project space");
    }

    public static ObserverBus getObserverBus() {
        return ESWorkspaceProviderImpl.getInstance().observerBus;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public ESWorkspaceImpl getWorkspace() {
        return (ESWorkspaceImpl)this.getInternalWorkspace().toAPI();
    }

    public Workspace getInternalWorkspace() {
        if (this.currentWorkspace == null) {
            this.load();
        }
        return this.currentWorkspace;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    @Override
    public void setSessionProvider(ESAbstractSessionProvider sessionProvider) {
        this.getSessionManager().setSessionProvider(sessionProvider);
    }

    private void initialize() {
        this.observerBus = new ObserverBus();
        this.connectionManager = this.initConnectionManager();
        this.adminConnectionManager = this.initAdminConnectionManager();
        this.sessionManager = new SessionManager();
        this.load();
    }

    private void notifyPostWorkspaceInitiators() {
        for (ESExtensionElement element : new ESExtensionPoint("org.eclipse.emf.emfstore.client.notify.postinit", true).getExtensionElements()) {
            try {
                ((ESWorkspaceInitObserver)element.getClass("class", ESWorkspaceInitObserver.class)).workspaceInitComplete((ESWorkspace)this.currentWorkspace.toAPI());
            }
            catch (ESExtensionPointException e) {
                WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private ConnectionManager initConnectionManager() {
        KeyStoreManager.getInstance().setupKeys();
        return new XmlRpcConnectionManager();
    }

    private AdminConnectionManager initAdminConnectionManager() {
        return new XmlRpcAdminConnectionManager();
    }

    private EditingDomain createEditingDomain(ResourceSet resourceSet) {
        ESEditingDomainProvider domainProvider = this.getDomainProvider();
        if (domainProvider != null) {
            return domainProvider.getEditingDomain(resourceSet);
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new EMFStoreBasicCommandStack(), resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return domain;
    }

    private ESEditingDomainProvider getDomainProvider() {
        return (ESEditingDomainProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.editingDomainProvider").getClass("class", ESEditingDomainProvider.class);
    }

    private Workspace createNewWorkspace(ResourceSet resourceSet, URI fileURI) {
        final Resource resource = resourceSet.createResource(fileURI);
        final Workspace workspace = ModelFactory.eINSTANCE.createWorkspace();
        workspace.getServerInfos().addAll(Configuration.getClientBehavior().getDefaultServerInfos());
        EList<Usersession> usersessions = workspace.getUsersessions();
        for (ServerInfo serverInfo : workspace.getServerInfos()) {
            Usersession lastUsersession = serverInfo.getLastUsersession();
            if (lastUsersession == null) continue;
            usersessions.add((Object)lastUsersession);
        }
        new EMFStoreCommand(){

            protected void doRun() {
                resource.getContents().add((Object)workspace);
            }
        }.run(true);
        try {
            resource.save(ModelUtil.getResourceSaveOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Creating new workspace failed! Delete workspace folder: " + Configuration.getFileInfo().getWorkspaceDirectory(), e);
        }
        return workspace;
    }

    private void migrateModelIfNeeded(ResourceSet resourceSet) {
        EMFStoreMigrator migrator = null;
        try {
            migrator = EMFStoreMigratorUtil.getEMFStoreMigrator();
        }
        catch (EMFStoreMigrationException e2) {
            WorkspaceUtil.logWarning(e2.getMessage(), null);
            return;
        }
        for (List<URI> curModels : this.getPhysicalURIsForMigration()) {
            if (!migrator.canHandle(curModels)) {
                return;
            }
            if (!migrator.needsMigration(curModels)) {
                return;
            }
            try {
                migrator.migrate(curModels, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (EMFStoreMigrationException e) {
                WorkspaceUtil.logException("The migration of the project in projectspace at " + curModels.get(0) + " failed!", (Exception)((Object)e));
            }
        }
    }

    private List<List<URI>> getPhysicalURIsForMigration() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.resourceSetProvider", true, (Comparator)new ESPriorityComparator("priority", true));
        ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
        ResourceSet migrationResourceSet = resourceSetProvider.getResourceSet();
        Resource resource = migrationResourceSet.createResource(ESClientURIUtil.createWorkspaceURI());
        try {
            resource.load(ModelUtil.getResourceLoadOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Error while loading workspace.", e);
        }
        ArrayList<List<URI>> physicalURIs = new ArrayList<List<URI>>();
        EList directContents = resource.getContents();
        Workspace workspace = (Workspace)directContents.get(0);
        for (ProjectSpace ps : workspace.getProjectSpaces()) {
            ArrayList<URI> uris = new ArrayList<URI>();
            URI projectURI = migrationResourceSet.getURIConverter().normalize(ps.getProject().eResource().getURI());
            URI operationsURI = migrationResourceSet.getURIConverter().normalize(ps.getLocalChangePackage().eResource().getURI());
            uris.add(projectURI);
            uris.add(operationsURI);
            physicalURIs.add(uris);
        }
        return physicalURIs;
    }

    @Override
    public void checkoutDone(ESLocalProject project) {
        this.flushCommandStack();
    }

    @Override
    public void shareDone(ESLocalProject localProject) {
        this.flushCommandStack();
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, List<ESChangePackage> changePackages, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void updateCompleted(ESLocalProject project, IProgressMonitor monitor) {
        this.flushCommandStack();
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, ESChangePackage changePackage, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void commitCompleted(ESLocalProject project, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        this.flushCommandStack();
    }
}

