/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.emfstore.internal.common.model.impl.NotifiableIdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectChangeNotifier
extends EContentAdapter {
    private final NotifiableIdEObjectCollectionImpl collection;
    private boolean isInitializing;
    private Stack<Notification> currentNotifications;
    private Stack<List<EObject>> removedModelElements;
    private int reentrantCallToAddAdapterCounter;
    private boolean notificationDisabled;

    public EObjectChangeNotifier(NotifiableIdEObjectCollectionImpl notifiableCollection, Notifier notifier) {
        this.collection = notifiableCollection;
        this.isInitializing = true;
        this.currentNotifications = new Stack();
        this.removedModelElements = new Stack();
        notifier.eAdapters().add((Object)this);
        this.isInitializing = false;
        this.reentrantCallToAddAdapterCounter = 0;
        this.notificationDisabled = false;
    }

    protected void addAdapter(Notifier notifier) {
        EObject modelElement;
        try {
            ++this.reentrantCallToAddAdapterCounter;
            if (!notifier.eAdapters().contains((Object)this)) {
                super.addAdapter(notifier);
            }
        }
        finally {
            --this.reentrantCallToAddAdapterCounter;
        }
        if (this.reentrantCallToAddAdapterCounter > 0 || this.currentNotifications.isEmpty()) {
            return;
        }
        Notification currentNotification = this.currentNotifications.peek();
        if (currentNotification != null && !currentNotification.isTouch() && !this.isInitializing && notifier instanceof EObject && !ModelUtil.isIgnoredDatatype((EObject)notifier) && !this.collection.contains(modelElement = (EObject)notifier) && this.isInCollectionHierarchy(modelElement)) {
            this.collection.modelElementAdded(this.collection, modelElement);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        EObject modelElement;
        EReference eReference;
        if (this.isInitializing || this.currentNotifications.isEmpty()) {
            return;
        }
        Notification currentNotification = this.currentNotifications.peek();
        if (currentNotification != null && currentNotification.isTouch()) {
            return;
        }
        if (currentNotification != null && currentNotification.getFeature() instanceof EReference && (eReference = (EReference)currentNotification.getFeature()).isContainment() && eReference.getEOpposite() != null && !eReference.getEOpposite().isTransient()) {
            return;
        }
        if (notifier instanceof EObject && !this.isInCollectionHierarchy(modelElement = (EObject)notifier) && (this.collection.contains(modelElement) || this.collection.getDeletedModelElementId(modelElement) != null)) {
            this.removedModelElements.peek().add(modelElement);
        }
    }

    private boolean isInCollectionHierarchy(EObject modelElement) {
        EObject parent = modelElement.eContainer();
        if (parent == null) {
            return false;
        }
        if (parent == this.collection) {
            return true;
        }
        if (this.collection.contains(parent)) {
            return true;
        }
        return this.isInCollectionHierarchy(parent);
    }

    public void notifyChanged(Notification notification) {
        if (this.notificationDisabled) {
            return;
        }
        this.removedModelElements.push(new ArrayList());
        this.currentNotifications.push(notification);
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        if (feature instanceof EReference) {
            EReference eReference = (EReference)feature;
            if (eReference.isTransient()) {
                return;
            }
            if (eReference.isContainer()) {
                this.handleContainer(notification, eReference);
            }
        }
        super.notifyChanged(notification);
        if (feature instanceof EReference && newValue != null && !notification.isTouch()) {
            EReference reference = (EReference)feature;
            if (!reference.isContainment() && !reference.isContainer()) {
                if (newValue instanceof EObject) {
                    this.handleSingleReference((EObject)newValue);
                } else if (newValue instanceof List) {
                    this.handleMultiReference((List)newValue);
                }
            } else if (reference.isContainment() && Map.Entry.class.isAssignableFrom(reference.getEType().getInstanceClass())) {
                this.handleMapEntry((Map.Entry)newValue, reference);
            }
        }
        this.currentNotifications.pop();
        if (!notification.isTouch() && notifier instanceof EObject && this.hasId(notifier)) {
            this.collection.notify(notification, this.collection, (EObject)notifier);
        }
        for (EObject removedElement : this.removedModelElements.pop()) {
            this.collection.modelElementRemoved(this.collection, removedElement);
        }
    }

    private boolean hasId(Object notifier) {
        return this.collection.getModelElementId((EObject)notifier) != null || this.collection.getDeletedModelElementId((EObject)notifier) != null;
    }

    private void handleMapEntry(Map.Entry<?, ?> entry, EReference reference) {
        for (EReference ref : reference.getEReferenceType().getEReferences()) {
            if (ref.getName().equals("key") && entry.getKey() instanceof EObject) {
                this.handleSingleReference((EObject)entry.getKey());
                continue;
            }
            if (!ref.getName().equals("value") || !(entry.getValue() instanceof EObject)) continue;
            this.handleSingleReference((EObject)entry.getValue());
        }
    }

    private void handleMultiReference(List<?> list) {
        for (Object obj : list) {
            EObject eObject;
            if (!(obj instanceof EObject) || this.collection.contains(eObject = (EObject)obj)) continue;
            this.collection.addCutElement(eObject);
        }
    }

    private void handleSingleReference(EObject newEObject) {
        if (!this.collection.contains(newEObject)) {
            if (ModelUtil.isSingleton(newEObject)) {
                return;
            }
            this.collection.addCutElement(newEObject);
        }
    }

    private void handleContainer(Notification notification, EReference eReference) {
        if (notification.getEventType() == 1) {
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            if (newValue == null && oldValue != null) {
                this.removeAdapter((Notifier)notification.getNotifier());
            }
        }
    }

    public void disableNotifications(boolean notificationDisabled) {
        this.notificationDisabled = notificationDisabled;
    }
}

