/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSingleConflict
extends VisualConflict {
    private static final String TARGET_KEY = "target";
    private static final String MULTIREFERENCE_SINGLECONFLICT_KEY = "multireferencesingleconflict";
    private static final String MULTIREF_GIF = "multiref.gif";
    private static final String OTHERCONTAINER_KEY = "othercontainer";

    public MultiReferenceSingleConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean multiLeft) {
        super(conflictBucket, decisionManager, multiLeft, true);
    }

    public MultiReferenceSingleConflict(MultiReferenceOperation multiReferenceOp, SingleReferenceOperation singleReferenceOp, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)multiReferenceOp, (AbstractOperation)singleReferenceOp, decisionManager, true, false);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SINGLECONFLICT_KEY, this.getDecisionManager().isBranchMerge()));
        description.add(TARGET_KEY, ((MultiReferenceOperation)this.getLeftOperation()).getReferencedModelElements().get(0));
        description.add(OTHERCONTAINER_KEY, this.getTheirOperation().getModelElementId());
        description.setImage(MULTIREF_GIF);
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        EObject target = this.getDecisionManager().getModelElement((ModelElementId)((MultiReferenceOperation)this.getLeftOperation()).getReferencedModelElements().get(0));
        myOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId()))));
        theirOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId()))));
        options.add(myOption);
        options.add(theirOption);
    }
}

