/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.controller.RevertCommitController;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESPrimaryVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRevertCommitController
extends AbstractEMFStoreUIController<Void> {
    private final ESPrimaryVersionSpecImpl versionSpec;
    private final ESLocalProjectImpl localProject;

    public UIRevertCommitController(Shell shell, ESPrimaryVersionSpec versionSpec, ESLocalProject localProject) {
        super(shell, false, false);
        this.localProject = (ESLocalProjectImpl)localProject;
        this.versionSpec = (ESPrimaryVersionSpecImpl)versionSpec;
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        InputDialog dialog = new InputDialog(null, Messages.UIRevertCommitController_Confirmation, MessageFormat.format(String.valueOf(Messages.UIRevertCommitController_RevertCommitPrompt_1) + Messages.UIRevertCommitController_RevertCommitPrompt_2, this.localProject.getProjectName()), this.createDefaultProjectName((ESLocalProject)this.localProject), new IInputValidator(){

            public String isValid(String newText) {
                if (StringUtils.isNotBlank((String)newText)) {
                    return null;
                }
                return Messages.UIRevertCommitController_InvalidProjectName;
            }
        });
        if (dialog.open() == 0) {
            PrimaryVersionSpec primaryVersionSpec = (PrimaryVersionSpec)ModelUtil.clone((EObject)((PrimaryVersionSpec)this.versionSpec.toInternalAPI()));
            String checkoutName = dialog.getValue();
            try {
                new RevertCommitController((ProjectSpace)this.localProject.toInternalAPI(), primaryVersionSpec, true, checkoutName).execute();
            }
            catch (ESException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.UIRevertCommitController_RevertFailed_Title, (String)MessageFormat.format(Messages.UIRevertCommitController_RevertFailed_Message, e.getMessage()));
            }
        }
        return null;
    }

    private String createDefaultProjectName(ESLocalProject project) {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        return String.valueOf(project.getProjectName()) + "@" + format.format(new Date());
    }
}

