/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.Iso;

public class IsoAlg {
    private static final boolean DEBUG = false;
    private static final IndentedWriter out = new IndentedWriter(System.out);
    private static Function<Triple, Tuple<Node>> tripleToTuple;

    public static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, EqualityTest nodeTest) {
        return IsoAlg.isIsomorphic(x1, x2, Iso.mappableBlankNodes, nodeTest);
    }

    public static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, Iso.Mappable mappable, EqualityTest nodeTest) {
        return IsoAlg.matcher(x1, x2, Mapping.rootMapping, mappable, nodeTest);
    }

    public static Mapping isIsomorphic(Tuple<Node> tuple1, Tuple<Node> tuple2, Mapping mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        return IsoAlg.gen(tuple1, tuple2, mapping, mappable, nodeTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean matcher(Collection<Tuple<Node>> tuples1, Collection<Tuple<Node>> tuples2, Mapping mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        if (tuples1.size() != tuples2.size()) {
            return false;
        }
        tuples2 = new HashSet<Tuple<Node>>(tuples2);
        ArrayList<Tuple<Node>> tuples1$ = new ArrayList<Tuple<Node>>();
        for (Tuple<Node> t1 : tuples1) {
            if (!IsoAlg.containsMappable(t1)) {
                boolean wasPresent = tuples2.remove(t1);
                if (wasPresent) continue;
                return false;
            }
            tuples1$.add(t1);
        }
        tuples1 = tuples1$;
        if (tuples1.size() != tuples2.size()) {
            return false;
        }
        Iterator<Tuple<Node>> iterator = tuples1.iterator();
        if (iterator.hasNext()) {
            Tuple<Node> t1 = iterator.next();
            tuples1.remove(t1);
            List<Possibility> causes = IsoAlg.matcher(t1, tuples2, mapping, mappable, nodeTest);
            out.incIndent();
            try {
                for (Possibility c : causes) {
                    Tuple<Node> t2 = c.tuple;
                    tuples2.remove(t2);
                    if (tuples1.isEmpty() && tuples2.isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (IsoAlg.matcher(tuples1, tuples2, c.mapping, mappable, nodeTest)) {
                        boolean bl = true;
                        return bl;
                    }
                    tuples2.add(t2);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                out.decIndent();
            }
        }
        return true;
    }

    private static boolean containsMappable(Tuple<Node> tuple) {
        for (Node n : tuple) {
            Tuple<Node> tuple1;
            boolean b;
            if (n.isBlank()) {
                return true;
            }
            if (n.isVariable()) {
                return true;
            }
            if (!n.isNodeTriple() || !(b = IsoAlg.containsMappable(tuple1 = tripleToTuple.apply(n.getTriple())))) continue;
            return true;
        }
        return false;
    }

    private static List<Possibility> matcher(Tuple<Node> t1, Collection<Tuple<Node>> g2, Mapping mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        ArrayList<Possibility> matches = new ArrayList<Possibility>();
        for (Tuple<Node> t2 : g2) {
            Mapping step = IsoAlg.gen(t1, t2, mapping, mappable, nodeTest);
            if (step == null) continue;
            Possibility c = new Possibility(t2, step);
            matches.add(c);
        }
        return matches;
    }

    private static Mapping gen(Tuple<Node> t1, Tuple<Node> t2, Mapping _mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        if (t1.len() != t2.len()) {
            return null;
        }
        Mapping mapping = _mapping;
        for (int i = 0; i < t1.len(); ++i) {
            Node n2;
            Node n1 = t1.get(i);
            Mapping mapping2 = IsoAlg.gen(n1, n2 = t2.get(i), mapping, mappable, nodeTest);
            if (mapping2 == null) {
                return null;
            }
            mapping = mapping2;
        }
        return mapping;
    }

    static Mapping gen(Node n1, Node n2, Mapping _mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        Mapping mapping = _mapping;
        Node n1m = mapping.map(n1);
        if (n1m != null) {
            if (n1m.equals(n2)) {
                return mapping;
            }
            return null;
        }
        if (n1.isNodeTriple()) {
            if (n2.isNodeTriple()) {
                Triple t1 = n1.getTriple();
                Triple t2 = n2.getTriple();
                Tuple<Node> tuple1 = tripleToTuple.apply(t1);
                Tuple<Node> tuple2 = tripleToTuple.apply(t2);
                return IsoAlg.gen(tuple1, tuple2, mapping, mappable, nodeTest);
            }
        } else if (n2.isNodeTriple()) {
            return null;
        }
        if (mappable.mappable(n1, n2)) {
            if (mapping.reverseMapped(n2)) {
                return null;
            }
            mapping = new Mapping(mapping, n1, n2);
            return mapping;
        }
        if (!nodeTest.equal(n1, n2)) {
            return null;
        }
        return mapping;
    }

    static {
        out.setFlushOnNewline(true);
        tripleToTuple = triple -> TupleFactory.tuple(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public static class Mapping {
        final Node node1;
        final Node node2;
        final Mapping parent;
        public static final Mapping rootMapping = new Mapping(null, null, null);

        public Mapping(Mapping parent, Node node1, Node node2) {
            this.parent = parent;
            this.node1 = node1;
            this.node2 = node2;
        }

        public boolean mapped(Node node) {
            return this.map(node) != null;
        }

        public Node map(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node1.equals(node)) {
                    return mapping.node2;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public boolean reverseMapped(Node node) {
            return this.reverseMap(node) != null;
        }

        public Node reverseMap(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node2.equals(node)) {
                    return mapping.node1;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            Mapping mapping = this;
            while (mapping != rootMapping) {
                sbuff.append("{" + mapping.node1 + " => " + mapping.node2 + "}");
                mapping = mapping.parent;
            }
            sbuff.append("{}");
            return sbuff.toString();
        }
    }

    static class Possibility {
        final Tuple<Node> tuple;
        final Mapping mapping;

        public Possibility(Tuple<Node> tuple, Mapping mapping) {
            this.tuple = tuple;
            this.mapping = mapping;
        }

        public String toString() {
            return String.format("Poss|%s %s|", this.tuple, this.mapping);
        }
    }
}

