/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFEventBasedExcelExtractor
extends POIXMLTextExtractor {
    private OPCPackage container;
    private POIXMLProperties properties;
    private Locale locale;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeTextBoxes = true;

    public XSSFEventBasedExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(OPCPackage.open(path));
    }

    public XSSFEventBasedExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super(null);
        this.container = container;
        this.properties = new POIXMLProperties(container);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFEventBasedExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFEventBasedExcelExtractor extractor = new XSSFEventBasedExcelExtractor(args[0]);
        System.out.println(extractor.getText());
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public void setIncludeTextBoxes(boolean includeTextBoxes) {
        this.includeTextBoxes = includeTextBoxes;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public OPCPackage getPackage() {
        return this.container;
    }

    @Override
    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.properties.getCoreProperties();
    }

    @Override
    public POIXMLProperties.ExtendedProperties getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    @Override
    public POIXMLProperties.CustomProperties getCustomProperties() {
        return this.properties.getCustomProperties();
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = this.locale == null ? new DataFormatter() : new DataFormatter(this.locale);
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, strings, sheetContentsExtractor, formatter, this.formulasNotResults);
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public String getText() {
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.container);
            XSSFReader xssfReader = new XSSFReader(this.container);
            StylesTable styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            StringBuffer text = new StringBuffer();
            SheetTextExtractor sheetExtractor = new SheetTextExtractor(text);
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                if (this.includeSheetNames) {
                    text.append(iter.getSheetName());
                    text.append('\n');
                }
                this.processSheet(sheetExtractor, styles, strings, stream);
                if (this.includeTextBoxes) {
                    this.processShapes(iter.getShapes(), text);
                }
                stream.close();
            }
            return text.toString();
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
        catch (SAXException se) {
            System.err.println(se);
            return null;
        }
        catch (OpenXML4JException o4je) {
            System.err.println(o4je);
            return null;
        }
    }

    private void processShapes(List<XSSFShape> shapes, StringBuffer text) {
        if (shapes == null) {
            return;
        }
        for (XSSFShape shape : shapes) {
            String sText;
            if (!(shape instanceof XSSFSimpleShape) || (sText = ((XSSFSimpleShape)shape).getText()) == null || sText.length() <= 0) continue;
            text.append(sText).append('\n');
        }
    }

    @Override
    public void close() throws IOException {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        super.close();
    }

    protected class SheetTextExtractor
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final StringBuffer output;
        private boolean firstCellOfRow = true;

        protected SheetTextExtractor(StringBuffer output) {
            this.output = output;
        }

        public void startRow(int rowNum) {
            this.firstCellOfRow = true;
        }

        public void endRow() {
            this.output.append('\n');
        }

        public void cell(String cellRef, String formattedValue) {
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            } else {
                this.output.append('\t');
            }
            this.output.append(formattedValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

