/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.QName;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementIterator
implements Iterator<Element> {
    private final Element element;
    private final ElementMetadata<?, ?> metadata;
    private final Map<QName, Object> elements;
    private Iterator<ElementKey<?, ?>> metadataIterator;
    private Iterator<? extends Element> sublistIterator;
    private Iterator<Object> elementIterator;
    private Element nextElement;
    private Mode mode = Mode.DECLARED;

    ElementIterator(Element element, ElementMetadata<?, ?> metadata, Map<QName, Object> elements) {
        this.element = element;
        this.metadata = metadata;
        this.elements = elements;
        this.metadataIterator = metadata == null ? null : metadata.getElements().iterator();
        this.elementIterator = elements == null ? null : elements.values().iterator();
        this.nextElement = this.findNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public Element next() {
        if (this.nextElement == null) {
            throw new NoSuchElementException("No remaining elements");
        }
        Element retval = this.nextElement;
        this.nextElement = this.findNextElement();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported on element iterator");
    }

    private Element findNextElement() {
        if (this.sublistIterator != null) {
            if (this.sublistIterator.hasNext()) {
                return this.sublistIterator.next();
            }
            this.sublistIterator = null;
        }
        Element next = null;
        block4: while (next == null && this.mode != Mode.DONE) {
            switch (this.mode) {
                case DECLARED: {
                    next = this.findNextDeclaredElement();
                    continue block4;
                }
                case UNDECLARED: {
                    next = this.findNextUndeclaredElement();
                    continue block4;
                }
            }
        }
        return next;
    }

    private Element findNextDeclaredElement() {
        if (this.metadataIterator != null) {
            while (this.metadataIterator.hasNext()) {
                Collection<? extends Element> virtualElements;
                Element generated;
                ElementKey<?, ?> nextKey = this.metadataIterator.next();
                if (ElementCreatorImpl.ELEMENT_MARKER == nextKey) {
                    this.mode = Mode.UNDECLARED;
                    return null;
                }
                ElementMetadata<?, ?> childMeta = this.metadata.bindElement(nextKey);
                if (!childMeta.isVisible()) continue;
                ElementMetadata.SingleVirtualElement singleVirtual = childMeta.getSingleVirtualElement();
                if (singleVirtual != null && (generated = singleVirtual.generateSingle(this.element, this.metadata, childMeta)) != null) {
                    return generated;
                }
                ElementMetadata.MultipleVirtualElement multipleVirtual = childMeta.getMultipleVirtualElement();
                if (multipleVirtual != null && (virtualElements = multipleVirtual.generateMultiple(this.element, this.metadata, childMeta)) != null && !virtualElements.isEmpty()) {
                    this.sublistIterator = virtualElements.iterator();
                    return this.sublistIterator.next();
                }
                Object obj = this.getElementObject(nextKey.getId());
                Element first = this.firstElement(obj);
                if (first == null) continue;
                return first;
            }
            this.metadataIterator = null;
        }
        this.mode = Mode.UNDECLARED;
        return null;
    }

    private Element findNextUndeclaredElement() {
        if (this.elementIterator != null) {
            while (this.elementIterator.hasNext()) {
                Object next = this.elementIterator.next();
                Element first = this.firstElement(next);
                if (first != null && this.isUndeclared(first.getElementKey())) {
                    return first;
                }
                this.sublistIterator = null;
            }
            this.sublistIterator = null;
            this.elementIterator = null;
        }
        this.mode = this.metadataIterator != null && this.metadataIterator.hasNext() ? Mode.DECLARED : Mode.DONE;
        return null;
    }

    private Element firstElement(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Element) {
            return (Element)obj;
        }
        Collection elementCollection = this.castElementCollection(obj);
        if (!elementCollection.isEmpty()) {
            this.sublistIterator = elementCollection.iterator();
            return this.sublistIterator.next();
        }
        return null;
    }

    private <T extends Element> Collection<T> castElementCollection(Object obj) {
        return (Collection)obj;
    }

    private Object getElementObject(QName id) {
        return this.elements != null ? this.elements.get(id) : null;
    }

    private boolean isUndeclared(ElementKey<?, ?> key) {
        return this.metadata == null || !this.metadata.isDeclared(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        DECLARED,
        UNDECLARED,
        DONE;

    }
}

