/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.base;

import com.google.gdata.util.common.base.Escaper;
import com.google.gdata.util.common.base.Preconditions;
import java.io.IOException;

public abstract class CharEscaper
implements Escaper {
    private static final int DEST_PAD = 32;
    private static final ThreadLocal<char[]> DEST_TL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    public String escape(String string) {
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            if (this.escape(string.charAt(index)) == null) continue;
            return this.escapeSlow(string, index);
        }
        return string;
    }

    public Appendable escape(final Appendable out) {
        Preconditions.checkNotNull(out);
        return new Appendable(){

            public Appendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                int unescapedChunkStart = start;
                for (int i = start; i < end; ++i) {
                    char[] escaped = CharEscaper.this.escape(csq.charAt(i));
                    if (escaped == null) continue;
                    if (unescapedChunkStart < i) {
                        out.append(csq, unescapedChunkStart, i);
                    }
                    this.outputChars(escaped);
                    unescapedChunkStart = i + 1;
                }
                if (unescapedChunkStart < end) {
                    out.append(csq, unescapedChunkStart, end);
                }
                return this;
            }

            public Appendable append(char c) throws IOException {
                char[] escaped = CharEscaper.this.escape(c);
                if (escaped == null) {
                    out.append(c);
                } else {
                    this.outputChars(escaped);
                }
                return this;
            }

            private void outputChars(char[] chars) throws IOException {
                for (char c : chars) {
                    out.append(c);
                }
            }
        };
    }

    protected String escapeSlow(String s, int index) {
        int slen = s.length();
        char[] dest = DEST_TL.get();
        int destSize = dest.length;
        int destIndex = 0;
        int lastEscape = 0;
        while (index < slen) {
            char[] r = this.escape(s.charAt(index));
            if (r != null) {
                int charsSkipped = index - lastEscape;
                int rlen = r.length;
                int sizeNeeded = destIndex + charsSkipped + rlen;
                if (destSize < sizeNeeded) {
                    destSize = sizeNeeded + (slen - index) + 32;
                    dest = CharEscaper.growBuffer(dest, destIndex, destSize);
                }
                if (charsSkipped > 0) {
                    s.getChars(lastEscape, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (rlen > 0) {
                    System.arraycopy(r, 0, dest, destIndex, rlen);
                    destIndex += rlen;
                }
                lastEscape = index + 1;
            }
            ++index;
        }
        int charsLeft = slen - lastEscape;
        if (charsLeft > 0) {
            int sizeNeeded = destIndex + charsLeft;
            if (destSize < sizeNeeded) {
                dest = CharEscaper.growBuffer(dest, destIndex, sizeNeeded);
            }
            s.getChars(lastEscape, slen, dest, destIndex);
            destIndex = sizeNeeded;
        }
        return new String(dest, 0, destIndex);
    }

    protected abstract char[] escape(char var1);

    private static final char[] growBuffer(char[] dest, int index, int size) {
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy(dest, 0, copy, 0, index);
        }
        return copy;
    }
}

