/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.gdata.model.Element;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import java.util.List;
import java.util.Map;

public class ContentValidationException
extends ServiceException {
    protected ValidationContext vc;

    public ContentValidationException(String message, ValidationContext vc) {
        super(message);
        this.vc = vc;
        this.setResponse(ContentType.TEXT_PLAIN, vc.toString());
    }

    public ValidationContext getContext() {
        return this.vc;
    }

    public ParseException toParseException() {
        ParseException result = null;
        Map<Element, List<ErrorContent>> errors = this.vc.getErrors();
        for (Map.Entry<Element, List<ErrorContent>> entry : errors.entrySet()) {
            Element element = entry.getKey();
            String location = element.getElementKey().getId().toString();
            List<ErrorContent> codes = entry.getValue();
            for (ErrorContent errorCode : codes) {
                ParseException pe = new ParseException(errorCode);
                pe.setLocation(location);
                if (result == null) {
                    result = pe;
                    continue;
                }
                result.addSibling(pe);
            }
        }
        return result;
    }
}

