/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.h2.Driver;
import org.h2.tools.Server;
import org.h2.util.StringUtils;

public class DbStarter
implements ServletContextListener {
    private Connection conn;
    private Server server;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Driver.load();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String string = this.getParameter(servletContext, "db.url", "jdbc:h2:~/test");
            String string2 = this.getParameter(servletContext, "db.user", "sa");
            String string3 = this.getParameter(servletContext, "db.password", "sa");
            this.conn = DriverManager.getConnection(string, string2, string3);
            servletContext.setAttribute("connection", (Object)this.conn);
            String string4 = this.getParameter(servletContext, "db.tcpServer", null);
            if (string4 != null) {
                String[] stringArray = StringUtils.arraySplit(string4, ' ', true);
                this.server = Server.createTcpServer(stringArray);
                this.server.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getParameter(ServletContext servletContext, String string, String string2) {
        String string3 = servletContext.getInitParameter(string);
        return string3 == null ? string2 : string3;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.conn.createStatement().execute("SHUTDOWN");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

