/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.Map;
import org.h2.util.Cache;
import org.h2.util.CacheObject;
import org.h2.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheSecondLevel
implements Cache {
    private final Cache baseCache;
    private final String prefix;
    private final Map<Integer, CacheObject> map;

    CacheSecondLevel(Cache cache, String string, Map<Integer, CacheObject> map) {
        this.baseCache = cache;
        this.prefix = string;
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.baseCache.clear();
    }

    @Override
    public CacheObject find(int n) {
        CacheObject cacheObject = this.baseCache.find(n);
        if (cacheObject == null) {
            cacheObject = this.map.get(n);
        }
        return cacheObject;
    }

    @Override
    public CacheObject get(int n) {
        CacheObject cacheObject = this.baseCache.get(n);
        if (cacheObject == null) {
            cacheObject = this.map.get(n);
        }
        return cacheObject;
    }

    @Override
    public ObjectArray<CacheObject> getAllChanged() {
        return this.baseCache.getAllChanged();
    }

    @Override
    public int getMaxSize() {
        return this.baseCache.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.baseCache.getSize();
    }

    @Override
    public String getTypeName() {
        return this.prefix + this.baseCache.getTypeName();
    }

    @Override
    public void put(CacheObject cacheObject) throws SQLException {
        this.baseCache.put(cacheObject);
        this.map.put(cacheObject.getPos(), cacheObject);
    }

    @Override
    public void remove(int n) {
        this.baseCache.remove(n);
        this.map.remove(n);
    }

    @Override
    public void setMaxSize(int n) throws SQLException {
        this.baseCache.setMaxSize(n);
    }

    @Override
    public CacheObject update(int n, CacheObject cacheObject) throws SQLException {
        CacheObject cacheObject2 = this.baseCache.update(n, cacheObject);
        this.map.put(n, cacheObject);
        return cacheObject2;
    }
}

