/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.New;
import org.h2.util.StatementBuilder;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static String toUpperEnglish(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerEnglish(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String quoteStringSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\'');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string)) + ")";
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String javaEncode(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n = c & 0xFFFF;
                    if (n >= 32 && n < 128) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    stringBuilder.append(Integer.toHexString(0x10000 | n).substring(1));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String addAsterisk(String string, int n) {
        if (string != null && n < string.length()) {
            string = string.substring(0, n) + "[*]" + string.substring(n);
        }
        return string;
    }

    private static SQLException getFormatException(String string, int n) {
        return Message.getSQLException(90095, StringUtils.addAsterisk(string, n));
    }

    public static String javaDecode(String string) throws SQLException {
        char c;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block17: for (int i = 0; i < string.length() && (c = string.charAt(i)) != '\"'; ++i) {
            if (c == '\\') {
                if (i >= string.length()) {
                    throw StringUtils.getFormatException(string, string.length() - 1);
                }
                c = string.charAt(++i);
                switch (c) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.getFormatException(string, i);
                        }
                        i += 4;
                        stringBuilder.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(string.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.getFormatException(string, i);
                            }
                            i += 2;
                            stringBuilder.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(string, i);
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteJavaString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string) + "\"";
    }

    public static byte[] utf8Encode(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    public static String utf8Decode(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    private static String utf8Decode(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new String[]{");
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(StringUtils.quoteJavaString(string));
        }
        return statementBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new int[]{");
        for (int n : nArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(n);
        }
        return statementBuilder.append('}').toString();
    }

    public static String enclose(String string) {
        if (string.startsWith("(")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unEnclose(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    public static String urlDecode(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                byArray[n++] = 32;
                continue;
            }
            if (c == '%') {
                byArray[n++] = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (SysProperties.CHECK && (c > '\u007f' || c < ' ')) {
                throw new IllegalArgumentException("unexpected char " + c + " decoding " + string);
            }
            byArray[n++] = (byte)c;
        }
        String string2 = StringUtils.utf8Decode(byArray, 0, n);
        return string2;
    }

    public static String[] arraySplit(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                String string2 = stringBuilder.toString();
                arrayList.add(bl ? string2.trim() : string2);
                stringBuilder.setLength(0);
                continue;
            }
            if (c2 == '\\' && i < string.length() - 1) {
                stringBuilder.append(string.charAt(++i));
                continue;
            }
            stringBuilder.append(c2);
        }
        String string3 = stringBuilder.toString();
        arrayList.add(bl ? string3.trim() : string3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String arrayCombine(String[] stringArray, char c) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(String.valueOf(c));
            if (string == null) {
                string = "";
            }
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == '\\' || c2 == c) {
                    statementBuilder.append('\\');
                }
                statementBuilder.append(c2);
            }
        }
        return statementBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) throws SQLException {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = StringUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) throws SQLException {
        SimpleDateFormat simpleDateFormat = StringUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw Message.getSQLException(90014, new String[]{string}, parseException);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) throws SQLException {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw Message.getSQLException(90014, new String[]{string + "/" + string2 + "/" + string3}, exception);
        }
    }

    public static String xmlAttr(String string, String string2) {
        return " " + string + "=\"" + StringUtils.xmlText(string2) + "\"";
    }

    public static String xmlNode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? string : string + string2;
        if (string3 == null) {
            return "<" + string4 + "/>\n";
        }
        if (string3.indexOf(10) >= 0) {
            string3 = "\n" + StringUtils.indent(string3);
        }
        return "<" + string4 + ">" + string3 + "</" + string + ">\n";
    }

    private static String indent(String string) {
        return StringUtils.indent(string, 4);
    }

    private static String indent(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + n);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuilder.append(' ');
            }
            n3 = string.indexOf(10, n2);
            n3 = n3 < 0 ? string.length() : n3 + 1;
            stringBuilder.append(string.substring(n2, n3));
            n2 = n3;
        }
        if (!string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String xmlComment(String string) {
        int n = 0;
        while ((n = string.indexOf("--", n)) >= 0) {
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(string) + "-->\n";
        }
        return "<!-- " + string + " -->\n";
    }

    public static String xmlCData(String string) {
        if (string.indexOf("]]>") >= 0) {
            return StringUtils.xmlText(string);
        }
        boolean bl = string.endsWith("\n");
        string = "<![CDATA[" + string + "]]>";
        return bl ? string + "\n" : string;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block8;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) < 0) break;
            stringBuilder.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String quoteIdentifier(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String quoteRemarkSQL(String string) {
        int n;
        while ((n = string.indexOf("*/")) >= 0) {
            string = string.substring(0, n) + "++/" + string.substring(n + 2);
        }
        while ((n = string.indexOf("/*")) >= 0) {
            string = string.substring(0, n) + "/++" + string.substring(n + 2);
        }
        return string;
    }

    public static String pad(String string, int n, String string2, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        if (n == string.length()) {
            return string;
        }
        char c = string2 == null || string2.length() == 0 ? (char)' ' : (char)string2.charAt(0);
        StringBuilder stringBuilder = new StringBuilder(n);
        n -= string.length();
        if (bl) {
            stringBuilder.append(string);
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    public static String trim(String string, boolean bl, boolean bl2, String string2) {
        int n;
        int n2;
        char c;
        char c2 = c = string2 == null || string2.length() < 1 ? (char)' ' : (char)string2.charAt(0);
        if (bl) {
            n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
            String string3 = string = n == 0 ? string : string.substring(n);
        }
        if (bl2) {
            for (n = n2 = string.length() - 1; n >= 0 && string.charAt(n) == c; --n) {
            }
            string = n == n2 ? string : string.substring(0, n + 1);
        }
        return string;
    }

    public static boolean isNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

