/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime.builtins;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.builtins.BuiltInDataTools;

public class BuiltInFileTools {
    private BuiltInFileTools() {
    }

    public static void cpfile(String source, String target, boolean overwrite) {
        Path targetPath;
        Path sourcePath;
        String absSource = org.eclipse.escet.common.app.framework.Paths.resolve((String)source);
        String absTarget = org.eclipse.escet.common.app.framework.Paths.resolve((String)target);
        try {
            sourcePath = Paths.get(absSource, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to copy file: source path \"%s\" is invalid.", (Object[])new Object[]{source});
            throw new ToolDefException(msg, ex);
        }
        try {
            targetPath = Paths.get(absTarget, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to copy file: target path \"%s\" is invalid.", (Object[])new Object[]{target});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to copy file: source path \"%s\" does not exist.", (Object[])new Object[]{source});
            throw new ToolDefException(msg);
        }
        if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to copy file: source path \"%s\" is not a file.", (Object[])new Object[]{source});
            throw new ToolDefException(msg);
        }
        if (Files.exists(targetPath, new LinkOption[0])) {
            if (!overwrite) {
                String msg = Strings.fmt((String)"Failed to copy file: target path \"%s\" already exists.", (Object[])new Object[]{target});
                throw new ToolDefException(msg);
            }
            if (!Files.isRegularFile(targetPath, new LinkOption[0])) {
                String msg = Strings.fmt((String)"Failed to copy file: target path \"%s\" exists but is not a file.", (Object[])new Object[]{target});
                throw new ToolDefException(msg);
            }
        }
        CopyOption[] options = overwrite ? new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING} : new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
        try {
            Files.copy(sourcePath, targetPath, options);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to copy file \"%s\" to \"%s\".", (Object[])new Object[]{source, target});
            throw new ToolDefException(msg, ex);
        }
    }

    public static void cpdir(String source, String target) {
        BuiltInFileTools.cpdir(source, target, "copy");
    }

    private static void cpdir(String source, String target, String op) {
        Path targetPath;
        Path sourcePath;
        String absSource = org.eclipse.escet.common.app.framework.Paths.resolve((String)source);
        String absTarget = org.eclipse.escet.common.app.framework.Paths.resolve((String)target);
        try {
            sourcePath = Paths.get(absSource, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory: source path \"%s\" is invalid.", (Object[])new Object[]{op, source});
            throw new ToolDefException(msg, ex);
        }
        try {
            targetPath = Paths.get(absTarget, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory: target path \"%s\" is invalid.", (Object[])new Object[]{op, target});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to %s directory: source path \"%s\" does not exist.", (Object[])new Object[]{op, source});
            throw new ToolDefException(msg);
        }
        if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to %s directory: source path \"%s\" is not a directory.", (Object[])new Object[]{op, source});
            throw new ToolDefException(msg);
        }
        if (Files.exists(targetPath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to %s directory: target path \"%s\" already exists.", (Object[])new Object[]{op, target});
            throw new ToolDefException(msg);
        }
        try {
            Files.createDirectories(targetPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory: could not create target directory \"%s\".", (Object[])new Object[]{op, target});
            throw new ToolDefException(msg, ex);
        }
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        DirCopier copier = new DirCopier(sourcePath, targetPath);
        try {
            Files.walkFileTree(sourcePath, options, Integer.MAX_VALUE, copier);
        }
        catch (IOException | ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory \"%s\" to \"%s\".", (Object[])new Object[]{op, source, target});
            throw new ToolDefException(msg, (Throwable)ex);
        }
    }

    public static boolean diff(String file1, String file2, String output, boolean missingAsEmpty, boolean warnOnDiff, boolean failOnDiff) {
        String msg;
        List lines2;
        List lines1;
        Path path2;
        Path path1;
        String absFile1 = org.eclipse.escet.common.app.framework.Paths.resolve((String)file1);
        String absFile2 = org.eclipse.escet.common.app.framework.Paths.resolve((String)file2);
        try {
            path1 = Paths.get(absFile1, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg2 = Strings.fmt((String)"Failed to diff file \"%s\": path is invalid.", (Object[])new Object[]{file1});
            throw new ToolDefException(msg2, ex);
        }
        try {
            path2 = Paths.get(absFile2, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg3 = Strings.fmt((String)"Failed to diff file \"%s\": path is invalid.", (Object[])new Object[]{file2});
            throw new ToolDefException(msg3, ex);
        }
        if (Files.exists(path1, new LinkOption[0])) {
            lines1 = BuiltInFileTools.readlines(file1);
        } else if (missingAsEmpty) {
            lines1 = Lists.list();
        } else {
            String msg4 = Strings.fmt((String)"Failed to diff file \"%s\": file not found.", (Object[])new Object[]{file1});
            throw new ToolDefException(msg4);
        }
        if (Files.exists(path2, new LinkOption[0])) {
            lines2 = BuiltInFileTools.readlines(file2);
        } else if (missingAsEmpty) {
            lines2 = Lists.list();
        } else {
            String msg5 = Strings.fmt((String)"Failed to diff file \"%s\": file not found.", (Object[])new Object[]{file2});
            throw new ToolDefException(msg5);
        }
        Patch patchResult = DiffUtils.diff((List)lines1, (List)lines2);
        boolean sameFiles = patchResult.getDeltas().isEmpty();
        if (!sameFiles && !output.equals("")) {
            try {
                boolean toFile;
                AppStream stream;
                if (output.equals("-")) {
                    stream = AppEnv.getStreams().out;
                    toFile = false;
                } else {
                    stream = new FileAppStream(output, org.eclipse.escet.common.app.framework.Paths.resolve((String)output));
                    toFile = true;
                }
                try {
                    boolean oldConvert = stream.getConvertNewLines();
                    stream.setConvertNewLines(false);
                    for (String line : UnifiedDiffUtils.generateUnifiedDiff((String)file1, (String)file2, (List)lines1, (Patch)patchResult, (int)3)) {
                        stream.println(line);
                    }
                    stream.flush();
                    stream.setConvertNewLines(oldConvert);
                }
                finally {
                    if (toFile) {
                        stream.close();
                    }
                }
            }
            catch (InputOutputException | ToolDefException ex) {
                String msg6 = Strings.fmt((String)"Failed to write diff to \"%s\".", (Object[])new Object[]{output});
                throw new ToolDefException(msg6, (Throwable)ex);
            }
        }
        if (!sameFiles && warnOnDiff) {
            msg = Strings.fmt((String)"Files \"%s\" and \"%s\" differ.", (Object[])new Object[]{file1, file2});
            OutputProvider.warn((String)msg);
        }
        if (!sameFiles && failOnDiff) {
            msg = Strings.fmt((String)"Files \"%s\" and \"%s\" differ.", (Object[])new Object[]{file1, file2});
            throw new ToolDefException(msg);
        }
        return !sameFiles;
    }

    public static boolean exists(String path) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to check whether path exists: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        return Files.exists(absJavaPath, new LinkOption[0]);
    }

    public static boolean filenewer(String path, String refpath, boolean allowNonExisting, boolean sameAsNewer) {
        return BuiltInFileTools.filenewer(path, Lists.list((Object)refpath), allowNonExisting, sameAsNewer);
    }

    public static boolean filenewer(String path, List<String> refpaths, boolean allowNonExisting, boolean sameAsNewer) {
        FileTime filetime;
        String msg;
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg2 = Strings.fmt((String)"Failed to determine if file is newer: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg2, ex);
        }
        List absRefPaths = Lists.listc((int)refpaths.size());
        for (String refpath : refpaths) {
            Path absJavaRefPath;
            String absRefPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)refpath);
            try {
                absJavaRefPath = Paths.get(absRefPath, new String[0]);
            }
            catch (InvalidPathException ex) {
                String msg3 = Strings.fmt((String)"Failed to determine if file is newer: path \"%s\" is invalid.", (Object[])new Object[]{refpath});
                throw new ToolDefException(msg3, ex);
            }
            absRefPaths.add(absJavaRefPath);
        }
        if (!allowNonExisting && !Files.exists(absJavaPath, new LinkOption[0])) {
            msg = Strings.fmt((String)"Failed to determine if file is newer: file \"%s\" does not exist.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (Files.exists(absJavaPath, new LinkOption[0]) && !Files.isRegularFile(absJavaPath, new LinkOption[0])) {
            msg = Strings.fmt((String)"Failed to determine if file is newer: path \"%s\" is not a file.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        int i = 0;
        while (i < refpaths.size()) {
            String msg4;
            if (!Files.exists((Path)absRefPaths.get(i), new LinkOption[0])) {
                msg4 = Strings.fmt((String)"Failed to determine if file is newer: file \"%s\" does not exist.", (Object[])new Object[]{refpaths.get(i)});
                throw new ToolDefException(msg4);
            }
            if (!Files.isRegularFile((Path)absRefPaths.get(i), new LinkOption[0])) {
                msg4 = Strings.fmt((String)"Failed to determine if file is newer: path \"%s\" is not a file.", (Object[])new Object[]{refpaths.get(i)});
                throw new ToolDefException(msg4);
            }
            ++i;
        }
        if (!Files.exists(absJavaPath, new LinkOption[0]) && allowNonExisting) {
            return false;
        }
        try {
            filetime = Files.getLastModifiedTime(absJavaPath, new LinkOption[0]);
        }
        catch (IOException ex) {
            String msg5 = Strings.fmt((String)"Failed to determine if file is newer: failed to get the last modified time of file \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg5, ex);
        }
        long filetimeMillis = filetime.toMillis();
        int i2 = 0;
        while (i2 < refpaths.size()) {
            FileTime reftime;
            try {
                reftime = Files.getLastModifiedTime((Path)absRefPaths.get(i2), new LinkOption[0]);
            }
            catch (IOException ex) {
                String msg6 = Strings.fmt((String)"Failed to determine if file is newer: failed to get the last modified time of file \"%s\".", (Object[])new Object[]{refpaths.get(i2)});
                throw new ToolDefException(msg6, ex);
            }
            long reftimeMillis = reftime.toMillis();
            if (filetimeMillis < reftimeMillis) {
                return false;
            }
            if (filetimeMillis == reftimeMillis && !sameAsNewer) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static long filesize(String path, boolean missingAsZero) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to get size of file: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(absJavaPath, new LinkOption[0])) {
            if (missingAsZero) {
                return 0L;
            }
            String msg = Strings.fmt((String)"Failed to get size of file: file \"%s\" does not exist.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (!Files.isRegularFile(absJavaPath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to get size of file: path \"%s\" is not a file.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        try {
            return Files.size(absJavaPath);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to get size of file \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    public static List<String> find(String path, String pattern, boolean recursive, boolean files, boolean dirs) {
        PathMatcher matcher;
        Path root;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            root = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to find in directory: root path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(root, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to find in directory: root path \"%s\" does not exist.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (!Files.isDirectory(root, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to find in directory: root path \"%s\" is not a directory.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        try {
            matcher = root.getFileSystem().getPathMatcher("glob:" + pattern);
        }
        catch (PatternSyntaxException ex) {
            String msg = Strings.fmt((String)"Failed to find in directory \"%s\": invalid pattern \"%s\".", (Object[])new Object[]{path, pattern});
            throw new ToolDefException(msg, ex);
        }
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Finder finder = new Finder(root, matcher, recursive, files, dirs);
        try {
            Files.walkFileTree(root, options, Integer.MAX_VALUE, finder);
        }
        catch (IOException | ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to find in directory \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        return BuiltInDataTools.sorted(finder.results);
    }

    public static boolean isdir(String path) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to check whether path refers to a directory: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        return Files.isDirectory(absJavaPath, new LinkOption[0]);
    }

    public static boolean isfile(String path) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to check whether path refers to a file: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        return Files.isRegularFile(absJavaPath, new LinkOption[0]);
    }

    public static void mkdir(String path, boolean force, boolean parents) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to create directory: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        if (Files.isDirectory(absJavaPath, new LinkOption[0])) {
            if (force) {
                return;
            }
            String msg = Strings.fmt((String)"Failed to create directory: directory \"%s\" already exists.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        try {
            if (parents) {
                Files.createDirectories(absJavaPath, new FileAttribute[0]);
            } else {
                Files.createDirectory(absJavaPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to create directory \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    public static void mvfile(String source, String target, boolean overwrite) {
        Path targetPath;
        Path sourcePath;
        String absSource = org.eclipse.escet.common.app.framework.Paths.resolve((String)source);
        String absTarget = org.eclipse.escet.common.app.framework.Paths.resolve((String)target);
        try {
            sourcePath = Paths.get(absSource, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to move file: source path \"%s\" is invalid.", (Object[])new Object[]{source});
            throw new ToolDefException(msg, ex);
        }
        try {
            targetPath = Paths.get(absTarget, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to move file: target path \"%s\" is invalid.", (Object[])new Object[]{target});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to move file: source path \"%s\" does not exist.", (Object[])new Object[]{source});
            throw new ToolDefException(msg);
        }
        if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to move file: source path \"%s\" is not a file.", (Object[])new Object[]{source});
            throw new ToolDefException(msg);
        }
        if (Files.exists(targetPath, new LinkOption[0])) {
            if (!overwrite) {
                String msg = Strings.fmt((String)"Failed to move file: target path \"%s\" already exists.", (Object[])new Object[]{target});
                throw new ToolDefException(msg);
            }
            if (!Files.isRegularFile(targetPath, new LinkOption[0])) {
                String msg = Strings.fmt((String)"Failed to move file: target path \"%s\" exists but is not a file.", (Object[])new Object[]{target});
                throw new ToolDefException(msg);
            }
        }
        CopyOption[] options = overwrite ? new CopyOption[]{StandardCopyOption.REPLACE_EXISTING} : new CopyOption[]{};
        try {
            Files.move(sourcePath, targetPath, options);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to move file \"%s\" to \"%s\".", (Object[])new Object[]{source, target});
            throw new ToolDefException(msg, ex);
        }
    }

    public static void mvdir(String source, String target) {
        BuiltInFileTools.cpdir(source, target, "move");
        BuiltInFileTools.rmdir(source, false, "move");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> readlines(String path) {
        String abspath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        ToolDefList<String> lines = new ToolDefList<String>();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                FileReader fileReader = new FileReader(abspath, StandardCharsets.UTF_8);
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        String line;
                        while ((line = bufferedReader.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    if (fileReader == null) return lines;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileReader == null) throw throwable;
                    fileReader.close();
                    throw throwable;
                }
                fileReader.close();
                return lines;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to read file \"%s\": the file does not exist, is a directory rather than a file, or for some other reason could not be opened for reading.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to read file \"%s\": an I/O error occurred.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    public static boolean rmfile(String path, boolean force) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to remove file: path \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
        if (!force && !Files.exists(absJavaPath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to remove file: file \"%s\" does not exist.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        if (!force && !Files.isRegularFile(absJavaPath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to remove file: path \"%s\" is not a file.", (Object[])new Object[]{path});
            throw new ToolDefException(msg);
        }
        try {
            if (force) {
                return Files.deleteIfExists(absJavaPath);
            }
            Files.delete(absJavaPath);
            return true;
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to remove file \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    public static boolean rmdir(String path, boolean force) {
        return BuiltInFileTools.rmdir(path, force, "remove");
    }

    private static boolean rmdir(String path, boolean force, String op) {
        Path absJavaPath;
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        try {
            absJavaPath = Paths.get(absPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory: path \"%s\" is invalid.", (Object[])new Object[]{op, path});
            throw new ToolDefException(msg, ex);
        }
        if (!Files.exists(absJavaPath, new LinkOption[0])) {
            if (force) {
                return false;
            }
            String msg = Strings.fmt((String)"Failed to %s directory: directory \"%s\" does not exist.", (Object[])new Object[]{op, path});
            throw new ToolDefException(msg);
        }
        if (!force && !Files.isDirectory(absJavaPath, new LinkOption[0])) {
            String msg = Strings.fmt((String)"Failed to %s directory: path \"%s\" is not a directory.", (Object[])new Object[]{op, path});
            throw new ToolDefException(msg);
        }
        DirRemover remover = new DirRemover();
        EnumSet<FileVisitOption> options = EnumSet.noneOf(FileVisitOption.class);
        try {
            Files.walkFileTree(absJavaPath, options, Integer.MAX_VALUE, remover);
        }
        catch (IOException | ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to %s directory \"%s\".", (Object[])new Object[]{op, path});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        return true;
    }

    public static void writefile(String path, String text, boolean append, String newline) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileAppStream stream = new FileAppStream(path, org.eclipse.escet.common.app.framework.Paths.resolve((String)path), append);){
                switch (newline) {
                    case "preserve": {
                        stream.setConvertNewLines(false);
                        break;
                    }
                    case "platform": {
                        stream.setConvertNewLines(true);
                        stream.setPlatformNewLineBytes();
                        break;
                    }
                    default: {
                        stream.setConvertNewLines(true);
                        stream.setNewLineBytes(newline.getBytes(stream.getCharset()));
                    }
                }
                stream.print(text);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = Strings.fmt((String)"Failed to write to file \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    public static void writefile(String path, List<String> lines, boolean append, String newline) {
        if ("preserve".equals(newline)) {
            throw new ToolDefException("Using \"preserve\" for \"newline\" is not supported when writing lines of text.");
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileAppStream stream = new FileAppStream(path, org.eclipse.escet.common.app.framework.Paths.resolve((String)path), append);){
                stream.setConvertNewLines(true);
                switch (newline) {
                    case "platform": {
                        stream.setPlatformNewLineBytes();
                        break;
                    }
                    default: {
                        stream.setNewLineBytes(newline.getBytes(stream.getCharset()));
                    }
                }
                for (String line : lines) {
                    stream.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = Strings.fmt((String)"Failed to write to file \"%s\".", (Object[])new Object[]{path});
            throw new ToolDefException(msg, ex);
        }
    }

    private static class DirCopier
    implements FileVisitor<Path> {
        private final Path target;
        private final Path source;

        public DirCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, options);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create directory \"%s\".", (Object[])new Object[]{newdir});
                throw new ToolDefException(msg, ex);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
            if (ex == null) {
                return FileVisitResult.CONTINUE;
            }
            String msg = Strings.fmt((String)"Failed to copy directory \"%s\".", (Object[])new Object[]{dir});
            throw new ToolDefException(msg, ex);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Path newfile = this.target.resolve(this.source.relativize(file));
            Files.copy(file, newfile, options);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ex) {
            if (ex instanceof FileSystemLoopException) {
                String msg = Strings.fmt((String)"File system cycle detected for file \"%s\".", (Object[])new Object[]{file});
                throw new ToolDefException(msg, ex);
            }
            String msg = Strings.fmt((String)"Failed to copy file \"%s\".", (Object[])new Object[]{file});
            throw new ToolDefException(msg, ex);
        }
    }

    private static class DirRemover
    implements FileVisitor<Path> {
        private DirRemover() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ex) {
            if (ex instanceof FileSystemLoopException) {
                String msg = Strings.fmt((String)"File system cycle detected for file \"%s\".", (Object[])new Object[]{file});
                throw new ToolDefException(msg, ex);
            }
            try {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
            catch (IOException ex2) {
                String msg = Strings.fmt((String)"Failed to remove file \"%s\".", (Object[])new Object[]{file});
                throw new ToolDefException(msg, ex2);
            }
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
            if (ex == null) {
                try {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                catch (IOException ex2) {
                    String msg = Strings.fmt((String)"Failed to remove directory \"%s\".", (Object[])new Object[]{dir});
                    throw new ToolDefException(msg, ex2);
                }
            }
            String msg = Strings.fmt((String)"Failed to remove directory \"%s\".", (Object[])new Object[]{dir});
            throw new ToolDefException(msg, ex);
        }
    }

    private static class Finder
    implements FileVisitor<Path> {
        private final Path root;
        private final PathMatcher matcher;
        private final boolean recursive;
        private final boolean files;
        private final boolean dirs;
        public List<String> results = new ToolDefList<String>();

        public Finder(Path root, PathMatcher matcher, boolean recursive, boolean files, boolean dirs) {
            this.root = root;
            this.matcher = matcher;
            this.recursive = recursive;
            this.files = files;
            this.dirs = dirs;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.dirs && !dir.equals(this.root) && this.matcher.matches(dir.getFileName())) {
                String rslt = this.root.relativize(dir).toString();
                this.results.add(rslt);
            }
            if (dir.equals(this.root)) {
                return FileVisitResult.CONTINUE;
            }
            return this.recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
            if (ex == null) {
                return FileVisitResult.CONTINUE;
            }
            String msg = Strings.fmt((String)"Failed to find in directory \"%s\".", (Object[])new Object[]{dir});
            throw new ToolDefException(msg, ex);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.files && this.matcher.matches(file.getFileName())) {
                String rslt = this.root.relativize(file).toString();
                this.results.add(rslt);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ex) {
            if (ex instanceof FileSystemLoopException) {
                String msg = Strings.fmt((String)"File system cycle detected for file \"%s\".", (Object[])new Object[]{file});
                throw new ToolDefException(msg, ex);
            }
            String msg = Strings.fmt((String)"Failed to find for file \"%s\".", (Object[])new Object[]{file});
            throw new ToolDefException(msg, ex);
        }
    }
}

