//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2023, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.datasynth.settings;

import static org.eclipse.escet.common.java.Sets.set;

import java.util.List;

import org.eclipse.escet.common.java.Assert;

/** Fixed-point computations order. */
public class FixedPointComputationsOrder {
    /** The computations to perform, in the order to perform them. */
    public final List<FixedPointComputation> computations;

    /**
     * Constructor of the {@link FixedPointComputationsOrder} class.
     *
     * @param computations The computations to perform, in the order to perform them.
     */
    public FixedPointComputationsOrder(FixedPointComputation... computations) {
        // Check that each computation is listed exactly once.
        Assert.areEqual(set(FixedPointComputation.values()), set(computations));

        this.computations = List.of(computations);
    }
}
