/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.UpdatesCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutomatonNormalCodeGenerator {
    private AutomatonNormalCodeGenerator() {
    }

    public static void gencodeAutomaton(Automaton aut, CifCompilerContext ctxt) {
        Location loc;
        String className = ctxt.getAutClassName(aut);
        JavaCodeFile file = ctxt.addCodeFile(className);
        String absName = CifTextUtils.getAbsName((PositionObject)aut);
        CodeBox h = file.header;
        h.add("/** Automaton \"%s\". */", new Object[]{absName});
        h.add("public final class %s extends RuntimeAutomaton<State> {", new Object[]{className});
        CodeBox c = file.body;
        c.add();
        c.add("@Override");
        c.add("public String getName() {");
        c.indent();
        c.add("return \"%s\";", new Object[]{absName});
        c.dedent();
        c.add("}");
        EList locs = aut.getLocations();
        c.add();
        c.add("@Override");
        c.add("public int getLocCount() {");
        c.indent();
        c.add("return %d;", new Object[]{locs.size()});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getCurLocName(State state) {");
        c.indent();
        c.add("return getLocName(state.%s.%s);", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getLocName(int locIdx) {");
        c.indent();
        c.add("switch (locIdx) {");
        c.indent();
        int i = 0;
        while (i < locs.size()) {
            loc = (Location)locs.get(i);
            String name = CifLocationUtils.getName((Location)loc);
            c.add("case %d: return \"%s\";", new Object[]{i, name});
            ++i;
        }
        c.add("default: throw new RuntimeException(\"Invalid loc idx: \" + locIdx);");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        AutomatonNormalCodeGenerator.gencodeFillSyncData(aut, ctxt, c);
        AutomatonNormalCodeGenerator.gencodeFillTauData(aut, ctxt, c);
        AutomatonNormalCodeGenerator.gencodeFillSendData(aut, ctxt, c);
        AutomatonNormalCodeGenerator.gencodeFillRecvData(aut, ctxt, c);
        int locIdx = 0;
        while (locIdx < locs.size()) {
            loc = (Location)locs.get(locIdx);
            String locTxt = CifTextUtils.getLocationText2((Location)loc);
            EList edges = loc.getEdges();
            int edgeIdx = 0;
            while (edgeIdx < edges.size()) {
                block7: {
                    EList edgeEvents;
                    boolean recvSeen;
                    boolean syncSeen;
                    Edge edge;
                    block6: {
                        edge = (Edge)edges.get(edgeIdx);
                        syncSeen = false;
                        recvSeen = false;
                        edgeEvents = edge.getEvents();
                        if (!edgeEvents.isEmpty()) break block6;
                        AutomatonNormalCodeGenerator.gencodeEdge(aut, loc, locIdx, locTxt, edge, edgeIdx, null, 0, ctxt, c);
                        break block7;
                    }
                    int eeIdx = 0;
                    while (eeIdx < edgeEvents.size()) {
                        block10: {
                            EdgeEvent edgeEvent;
                            block8: {
                                block9: {
                                    edgeEvent = (EdgeEvent)edgeEvents.get(eeIdx);
                                    if (edgeEvent instanceof EdgeSend) break block8;
                                    if (!(edgeEvent instanceof EdgeReceive)) break block9;
                                    if (recvSeen) break block10;
                                    recvSeen = true;
                                    break block8;
                                }
                                if (syncSeen) break block10;
                                syncSeen = true;
                            }
                            AutomatonNormalCodeGenerator.gencodeEdge(aut, loc, locIdx, locTxt, edge, edgeIdx, edgeEvent, eeIdx, ctxt, c);
                        }
                        ++eeIdx;
                    }
                }
                ++edgeIdx;
            }
            ++locIdx;
        }
    }

    private static void gencodeFillSyncData(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        Set<Event> syncAlphabet = ctxt.getAlphabet(aut);
        List<Event> events = ctxt.getEvents();
        for (Event event : events) {
            if (!syncAlphabet.contains(event)) continue;
            List<Automaton> auts = ctxt.getSyncAuts(event);
            int autIdx = auts.indexOf(aut);
            int runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            c.add();
            c.add("public static boolean fillSyncData_%d(State state) {", new Object[]{runtimeEventIdx});
            c.indent();
            c.add("List<RuntimeEdge<State>> rslt = SPEC.syncData.get(%d).get(%d);", new Object[]{runtimeEventIdx, autIdx});
            c.add("rslt.clear();");
            c.add();
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                boolean caseAdded = false;
                EList edges = loc.getEdges();
                int edgeIdx = 0;
                while (edgeIdx < edges.size()) {
                    Edge edge = (Edge)edges.get(edgeIdx);
                    int reprIdx = -1;
                    EList edgeEvents = edge.getEvents();
                    int eeIdx = 0;
                    while (eeIdx < edgeEvents.size()) {
                        EdgeEvent edgeEvent = (EdgeEvent)edgeEvents.get(eeIdx);
                        if (!(edgeEvent instanceof EdgeSend) && !(edgeEvent instanceof EdgeReceive)) {
                            Event e;
                            Expression eventRef;
                            if (reprIdx == -1) {
                                reprIdx = eeIdx;
                            }
                            if (!((eventRef = edgeEvent.getEvent()) instanceof TauExpression) && (e = ((EventExpression)eventRef).getEvent()) == event) {
                                if (!caseAdded) {
                                    caseAdded = true;
                                    c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                                    c.indent();
                                }
                                String postfix = Strings.fmt((String)"%d_%d_%d", (Object[])new Object[]{locIdx, edgeIdx, reprIdx});
                                c.add("if (sync%s.evalGuards(state)) rslt.add(sync%s);", new Object[]{postfix, postfix});
                            }
                        }
                        ++eeIdx;
                    }
                    ++edgeIdx;
                }
                if (caseAdded) {
                    c.add("break;");
                    c.dedent();
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
            Set<Event> monitors = ctxt.getMonitors(aut);
            if (monitors.contains(event)) {
                c.add();
                c.add("// Monitor.");
                c.add("if (rslt.isEmpty()) rslt.add(MONITOR_EDGE);");
            }
            c.add();
            c.add("return !rslt.isEmpty();");
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeFillTauData(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        c.add();
        c.add("public static void fillTauData(State state) {");
        c.indent();
        c.add("List<RuntimeEdge<State>> edgeData;");
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            boolean caseAdded = false;
            EList edges = loc.getEdges();
            int edgeIdx = 0;
            while (edgeIdx < edges.size()) {
                Edge edge = (Edge)edges.get(edgeIdx);
                int reprIdx = -1;
                Object edgeEvents = edge.getEvents();
                if (edgeEvents.isEmpty()) {
                    edgeEvents = Lists.list(null);
                }
                int eeIdx = 0;
                while (eeIdx < edgeEvents.size()) {
                    EdgeEvent edgeEvent = (EdgeEvent)edgeEvents.get(eeIdx);
                    if (!(edgeEvent instanceof EdgeSend) && !(edgeEvent instanceof EdgeReceive)) {
                        Expression eventRef;
                        if (reprIdx == -1) {
                            reprIdx = eeIdx;
                        }
                        if (edgeEvent == null || !((eventRef = edgeEvent.getEvent()) instanceof EventExpression)) {
                            ctxt.hasTauEdge = true;
                            if (!caseAdded) {
                                caseAdded = true;
                                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                                c.indent();
                            }
                            String postfix = Strings.fmt((String)"%d_%d_%d", (Object[])new Object[]{locIdx, edgeIdx, reprIdx});
                            c.add("if (sync%s.evalGuards(state)) {", new Object[]{postfix});
                            c.indent();
                            c.add("edgeData = list((RuntimeEdge<State>)sync%s);", new Object[]{postfix});
                            c.add("SPEC.tauData.add(edgeData);");
                            c.dedent();
                            c.add("}");
                        }
                    }
                    ++eeIdx;
                }
                ++edgeIdx;
            }
            if (caseAdded) {
                c.add("break;");
                c.dedent();
            }
            ++locIdx;
        }
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
    }

    private static void gencodeFillSendData(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        Set<Event> sendAlphabet = ctxt.getSendAlphabet(aut);
        List<Event> events = ctxt.getEvents();
        for (Event event : events) {
            if (!sendAlphabet.contains(event)) continue;
            int runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            c.add();
            c.add("public static void fillSendData_%d(State state) {", new Object[]{runtimeEventIdx});
            c.indent();
            c.add("List<RuntimeEdge<State>> rslt = SPEC.sendData.get(%d);", new Object[]{runtimeEventIdx});
            c.add();
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                boolean caseAdded = false;
                EList edges = loc.getEdges();
                int edgeIdx = 0;
                while (edgeIdx < edges.size()) {
                    Edge edge = (Edge)edges.get(edgeIdx);
                    EList edgeEvents = edge.getEvents();
                    int eeIdx = 0;
                    while (eeIdx < edgeEvents.size()) {
                        Expression eventRef;
                        Event e;
                        EdgeEvent edgeEvent = (EdgeEvent)edgeEvents.get(eeIdx);
                        if (edgeEvent instanceof EdgeSend && (e = ((EventExpression)(eventRef = edgeEvent.getEvent())).getEvent()) == event) {
                            if (!caseAdded) {
                                caseAdded = true;
                                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                                c.indent();
                            }
                            String postfix = Strings.fmt((String)"%d_%d_%d", (Object[])new Object[]{locIdx, edgeIdx, eeIdx});
                            c.add("if (send%s.evalGuards(state)) rslt.add(send%s);", new Object[]{postfix, postfix});
                        }
                        ++eeIdx;
                    }
                    ++edgeIdx;
                }
                if (caseAdded) {
                    c.add("break;");
                    c.dedent();
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeFillRecvData(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        Set<Event> rcvAlphabet = ctxt.getReceiveAlphabet(aut);
        List<Event> events = ctxt.getEvents();
        for (Event event : events) {
            if (!rcvAlphabet.contains(event)) continue;
            int runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            c.add();
            c.add("public static void fillRecvData_%d(State state) {", new Object[]{runtimeEventIdx});
            c.indent();
            c.add("List<RuntimeEdge<State>> rslt = SPEC.recvData.get(%d);", new Object[]{runtimeEventIdx});
            c.add();
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                boolean caseAdded = false;
                EList edges = loc.getEdges();
                int edgeIdx = 0;
                while (edgeIdx < edges.size()) {
                    Edge edge = (Edge)edges.get(edgeIdx);
                    int reprIdx = -1;
                    EList edgeEvents = edge.getEvents();
                    int eeIdx = 0;
                    while (eeIdx < edgeEvents.size()) {
                        EdgeEvent edgeEvent = (EdgeEvent)edgeEvents.get(eeIdx);
                        if (edgeEvent instanceof EdgeReceive) {
                            Expression eventRef;
                            Event e;
                            if (reprIdx == -1) {
                                reprIdx = eeIdx;
                            }
                            if ((e = ((EventExpression)(eventRef = edgeEvent.getEvent())).getEvent()) == event) {
                                if (!caseAdded) {
                                    caseAdded = true;
                                    c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                                    c.indent();
                                }
                                String postfix = Strings.fmt((String)"%d_%d_%d", (Object[])new Object[]{locIdx, edgeIdx, reprIdx});
                                c.add("if (receive%s.evalGuards(state)) rslt.add(receive%s);", new Object[]{postfix, postfix});
                            }
                        }
                        ++eeIdx;
                    }
                    ++edgeIdx;
                }
                if (caseAdded) {
                    c.add("break;");
                    c.dedent();
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeEdge(Automaton aut, Location loc, int locIdx, String locTxt, Edge edge, int edgeIdx, EdgeEvent edgeEvent, int eeReprIdx, CifCompilerContext ctxt, CodeBox c) {
        Object result;
        boolean isSend = edgeEvent instanceof EdgeSend;
        boolean isRecv = edgeEvent instanceof EdgeReceive;
        String useName = isSend ? "Send" : (isRecv ? "Receive" : "Sync");
        String postfix = Strings.fmt((String)"%d_%d_%d", (Object[])new Object[]{locIdx, edgeIdx, eeReprIdx});
        c.add();
        c.add("private static final %s%s %s%s = new %s%s();", new Object[]{useName, postfix, useName.toLowerCase(Locale.US), postfix, useName, postfix});
        c.add();
        c.add("private static final class %s%s extends Runtime%sEdge<State> {", new Object[]{useName, postfix, useName});
        c.indent();
        c.add("@Override");
        c.add("public boolean evalGuards(State state) {");
        c.indent();
        List guardResults = Lists.list();
        if (edge.getGuards().isEmpty()) {
            c.add("return true;");
        } else {
            c.add("boolean b;");
            for (Expression guard : edge.getGuards()) {
                c.add("try {");
                c.indent();
                result = ExprCodeGenerator.gencodeExpr(guard, ctxt, "state");
                c.add("b = %s;", new Object[]{result});
                guardResults.add(result);
                c.dedent();
                c.add("} catch (CifSimulatorException e) {");
                c.indent();
                c.add("throw new CifSimulatorException(\"Evaluation of guard \\\"%s\\\" of an edge of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprToStr((Expression)guard), (int)1000)), StringEscapeUtils.escapeJava((String)locTxt)});
                c.dedent();
                c.add("}");
                c.add("if (!b) return false;");
            }
            c.add("return true;");
        }
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult guardResult : guardResults) {
            guardResult.addExtraMethods(c);
        }
        List sendResults = Lists.list();
        if (isSend) {
            c.add();
            c.add("@Override");
            c.add("public Object evalSendValue(State state) {");
            c.indent();
            Expression sendValue = ((EdgeSend)edgeEvent).getValue();
            if (sendValue == null) {
                c.add("return null; // void");
            } else {
                c.add("try {");
                c.indent();
                result = ExprCodeGenerator.gencodeExpr(sendValue, ctxt, "state");
                c.add("return %s;", new Object[]{result});
                sendResults.add(result);
                c.dedent();
                c.add("} catch (CifSimulatorException e) {");
                c.indent();
                c.add("throw new CifSimulatorException(\"Evaluation of value \\\"%s\\\" to send of an edge of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprToStr((Expression)sendValue), (int)1000)), StringEscapeUtils.escapeJava((String)locTxt)});
                c.dedent();
                c.add("}");
            }
            c.dedent();
            c.add("}");
        }
        for (ExprCodeGeneratorResult sendResult : sendResults) {
            sendResult.addExtraMethods(c);
        }
        c.add();
        c.add("@Override");
        if (isRecv) {
            c.add("public void update(State source, State target, Object %s_) {", new Object[]{"rcvd"});
        } else {
            c.add("public void update(State source, State target) {");
        }
        c.indent();
        boolean selfLoop = CifEdgeUtils.isSelfLoop((Edge)edge);
        boolean noUpdates = selfLoop && edge.getUpdates().isEmpty();
        List updateResults = Lists.list();
        if (noUpdates) {
            c.add("// No updates.");
        } else {
            Event event;
            if (isRecv && !((event = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent)).getType() instanceof VoidType)) {
                c.add("%s %s = (%s)%s_;", new Object[]{TypeCodeGenerator.gencodeType(event.getType(), ctxt), "rcvd", TypeCodeGenerator.gencodeType(event.getType(), ctxt), "rcvd"});
            }
            c.add("boolean b; // temp var for pred eval rslts");
            c.add("target.%s = source.%s.copy();", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutSubStateFieldName(aut)});
            if (!selfLoop) {
                c.add("target.%s.%s = %s;", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut), ctxt.getLocationValueText(edge.getTarget())});
            }
            c.add("try {");
            c.indent();
            updateResults.addAll(UpdatesCodeGenerator.gencodeUpdates(c, aut, ctxt, (List<Update>)edge.getUpdates(), "source"));
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Execution of the updates of an edge of %s failed.\", e, source);", new Object[]{StringEscapeUtils.escapeJava((String)locTxt)});
            c.dedent();
            c.add("}");
        }
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult updateResult : updateResults) {
            updateResult.addExtraMethods(c);
        }
        c.dedent();
        c.add("}");
    }
}

