/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.io;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.io.RuntimeToStringable;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class RuntimeValueToString {
    private RuntimeValueToString() {
    }

    public static String runtimeToString(Object value) {
        if (value instanceof RuntimeToStringable) {
            return RuntimeValueToString.runtimeToString((RuntimeToStringable)value);
        }
        if (value instanceof Boolean) {
            boolean bvalue = (Boolean)value;
            return RuntimeValueToString.runtimeToString(bvalue);
        }
        if (value instanceof Integer) {
            int ivalue = (Integer)value;
            return RuntimeValueToString.runtimeToString(ivalue);
        }
        if (value instanceof Double) {
            double dvalue = (Double)value;
            return RuntimeValueToString.runtimeToString(dvalue);
        }
        if (value instanceof String) {
            return RuntimeValueToString.runtimeToString((String)value);
        }
        if (value instanceof List) {
            return RuntimeValueToString.runtimeToString((List)value);
        }
        if (value instanceof Set) {
            return RuntimeValueToString.runtimeToString((Set)value);
        }
        if (value instanceof Map) {
            return RuntimeValueToString.runtimeToString((Map)value);
        }
        throw new RuntimeException("Unknown runtime value: " + String.valueOf(value));
    }

    public static String runtimeToString(RuntimeToStringable value) {
        return value.toString();
    }

    public static String runtimeToString(boolean value) {
        return CifSimulatorMath.boolToStr(value);
    }

    public static String runtimeToString(int value) {
        return CifSimulatorMath.intToStr(value);
    }

    public static String runtimeToString(double value) {
        return CifSimulatorMath.realToStr(value);
    }

    public static String runtimeToString(String value) {
        return "\"" + Strings.escape((String)value) + "\"";
    }

    public static <T> String runtimeToString(List<T> value) {
        List elems = Lists.listc((int)value.size());
        for (T elem : value) {
            elems.add(RuntimeValueToString.runtimeToString(elem));
        }
        return "[" + String.join((CharSequence)", ", elems) + "]";
    }

    public static <T> String runtimeToString(Set<T> value) {
        Assert.check((boolean)(value instanceof LinkedHashSet));
        List elems = Lists.listc((int)value.size());
        for (T elem : value) {
            elems.add(RuntimeValueToString.runtimeToString(elem));
        }
        return "{" + String.join((CharSequence)", ", elems) + "}";
    }

    public static <K, V> String runtimeToString(Map<K, V> value) {
        Assert.check((boolean)(value instanceof LinkedHashMap));
        List elems = Lists.listc((int)value.size());
        for (Map.Entry<K, V> pair : value.entrySet()) {
            elems.add(RuntimeValueToString.runtimeToString(pair.getKey()) + ": " + RuntimeValueToString.runtimeToString(pair.getValue()));
        }
        return "{" + String.join((CharSequence)", ", elems) + "}";
    }
}

