/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.validation;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.converter.BaseConverterService;
import org.eclipse.etrice.core.common.converter.CCStringIndentation;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.services.FSMGrammarAccess;
import org.eclipse.etrice.core.fsm.validation.AbstractFSMValidator;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtil;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;

public class FSMValidator
extends AbstractFSMValidator {
    public static final String PLAIN_STRING_DETAILCODE = "RoomJavaValidator.PlainStringDetailCode";
    @Inject
    private FSMValidationUtil validationUtil;
    @Inject
    FSMGrammarAccess grammar;
    @Inject
    BaseConverterService converterService;

    @Check
    public void checkRefinedStateUnique(RefinedState rs) {
        StateGraph sg = (StateGraph)rs.eContainer();
        TreeIterator it = sg.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj == rs || !(obj instanceof RefinedState) || rs.getTarget() != ((RefinedState)obj).getTarget()) continue;
            if (rs.eContainer().eContainer() instanceof ModelComponent) {
                this.error("refined state conflicts with nested refined state with same target", (EStructuralFeature)FSMPackage.Literals.REFINED_STATE__TARGET);
                continue;
            }
            this.error("refined state not unique", (EStructuralFeature)FSMPackage.Literals.REFINED_STATE__TARGET);
        }
    }

    @Check
    public void checkRefinedStateNotEmpty(RefinedState rs) {
        if (this.validationUtil.isRefinedStateEmpty(rs)) {
            this.error("Refined state must not be empty (needs to have at least one action code or a subgraph).", (EStructuralFeature)FSMPackage.Literals.STATE__ENTRY_CODE);
        }
    }

    @Check
    public void checkStateNameUnique(SimpleState s) {
    }

    @Check
    public void checkTrPoint(TrPoint tp) {
        FSMValidationUtilXtend.Result result = this.validationUtil.isValid(tp);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkChoicePoint(ChoicePoint cp) {
    }

    @Check
    public void checkTransition(Transition trans) {
        FSMValidationUtilXtend.Result result = this.validationUtil.checkTransition(trans);
        if (!result.isOk()) {
            this.error(result);
        }
        if (!(result = trans instanceof InitialTransition ? this.validationUtil.isConnectable(null, trans.getTo(), trans, (StateGraph)trans.eContainer()) : this.validationUtil.isConnectable(((NonInitialTransition)trans).getFrom(), trans.getTo(), trans, (StateGraph)trans.eContainer())).isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkState(State state) {
        FSMValidationUtilXtend.Result result = this.validationUtil.checkState(state);
        if (!result.isOk()) {
            this.error(result);
        }
        ArrayList<FSMValidationUtilXtend.Result> res = this.validationUtil.uniqueOriginTriggers(state);
        for (FSMValidationUtilXtend.Result r : res) {
            this.error(r);
        }
    }

    @Check
    public void checkRefinedTransition(RefinedTransition rt) {
        if (!(rt.eContainer().eContainer() instanceof ModelComponent)) {
            StateGraph sg = (StateGraph)rt.eContainer();
            int idx = sg.getRefinedTransitions().indexOf((Object)rt);
            this.error("RefinedTransition only allowed in top level state graph of an actor", sg, (EStructuralFeature)FSMPackage.Literals.STATE_GRAPH__REFINED_TRANSITIONS, idx);
        }
    }

    @Check
    public void checkDetailCode(DetailCode dc) {
        if (dc.getLines().isEmpty()) {
            this.error("detail code must not be empty", dc, (EStructuralFeature)FSMPackage.Literals.DETAIL_CODE__LINES);
            return;
        }
        boolean isPlainStyle = false;
        List lineNodes = NodeModelUtils.findNodesForFeature((EObject)dc, (EStructuralFeature)FSMPackage.Literals.DETAIL_CODE__LINES);
        for (INode lineNode : lineNodes) {
            if (!(lineNode.getGrammarElement() instanceof RuleCall)) continue;
            AbstractRule rule = ((RuleCall)lineNode.getGrammarElement()).getRule();
            if (rule == this.grammar.getCC_STRINGRule()) {
                if (new CCStringIndentation(this.converterService.getCC_StringConverter().stripDelim(lineNode.getText())).hasConsistentIndentation()) continue;
                this.warning("Inconsistent indentation", dc, (EStructuralFeature)FSMPackage.Literals.DETAIL_CODE__LINES, lineNodes.indexOf(lineNode));
                continue;
            }
            if (rule != this.grammar.getSTRINGRule()) continue;
            isPlainStyle = true;
            if (Strings.countLineBreaks((CharSequence)lineNode.getText()) <= 0) continue;
            this.warning("multi line string, use smart string instead", dc, (EStructuralFeature)FSMPackage.Literals.DETAIL_CODE__LINES, lineNodes.indexOf(lineNode));
        }
        if (isPlainStyle) {
            this.warning("old style line string", dc, null, PLAIN_STRING_DETAILCODE, new String[0]);
        }
    }

    @Check
    public void checkUniqueNamesInStateGraph(StateGraph sg) {
        ArrayListMultimap names2items = ArrayListMultimap.create();
        StateGraph stateGraph = sg;
        do {
            for (State st : stateGraph.getStates()) {
                if (st instanceof RefinedState) continue;
                names2items.put((Object)st.getName(), (Object)st);
            }
            for (TrPoint tp : stateGraph.getTrPoints()) {
                names2items.put((Object)tp.getName(), (Object)tp);
            }
            for (ChoicePoint cp : stateGraph.getChPoints()) {
                names2items.put((Object)cp.getName(), (Object)cp);
            }
            for (Transition tr : stateGraph.getTransitions()) {
                names2items.put((Object)tr.getName(), (Object)tr);
            }
            if (stateGraph.eContainer() instanceof RefinedState) {
                stateGraph = ((RefinedState)stateGraph.eContainer()).getTarget().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ModelComponent)) break;
            ModelComponent base = ((ModelComponent)stateGraph.eContainer()).getBase();
            StateGraph stateGraph2 = stateGraph = base != null ? base.getStateMachine() : null;
        } while (stateGraph != null);
        for (String key : names2items.keySet()) {
            Collection list = names2items.get((Object)key);
            if (list.size() <= 1) continue;
            for (StateGraphItem item : list) {
                if (sg.eContents().contains((Object)item)) {
                    this.error("Name is not unique in state graph (including super graph)", item, this.getNameFeature(item));
                    continue;
                }
                if (sg.eResource() != item.eResource()) continue;
                this.warning("Name is also used in derived graph(s)", item, this.getNameFeature(item));
            }
        }
    }

    private EStructuralFeature getNameFeature(StateGraphItem item) {
        if (item instanceof SimpleState) {
            return FSMPackage.Literals.SIMPLE_STATE__NAME;
        }
        if (item instanceof ChoicePoint) {
            return FSMPackage.Literals.CHOICE_POINT__NAME;
        }
        if (item instanceof TrPoint) {
            return FSMPackage.Literals.TR_POINT__NAME;
        }
        if (item instanceof Transition) {
            return FSMPackage.Literals.TRANSITION__NAME;
        }
        assert (false) : "internal error: unexpected sub type";
        return null;
    }

    private void error(FSMValidationUtilXtend.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex(), "no_special_code", new String[]{"blocking_marker"});
    }
}

