/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.fsm.generic.ITransitionChainVisitor;

public class TransitionChainVisitor
implements ITransitionChainVisitor {
    private GraphContainer gc;
    private ILanguageExtensionBase langExt;
    private CodegenHelpers codegenHelpers;
    private IDetailCodeTranslator translationProvider;
    private boolean dataDriven = false;

    protected TransitionChainVisitor(GraphContainer gc, ILanguageExtensionBase languageExt, CodegenHelpers codegenHelpers, IDetailCodeTranslator translationProvider) {
        this.gc = gc;
        this.langExt = languageExt;
        this.codegenHelpers = codegenHelpers;
        this.translationProvider = translationProvider;
    }

    protected void init(Transition tr) {
        if (tr instanceof GuardedTransition) {
            this.dataDriven = true;
        } else if (tr instanceof InitialTransition) {
            this.dataDriven = true;
        }
    }

    @Override
    public String genActionOperationCall(Transition tr) {
        boolean noIfItem = this.dataDriven;
        Link l = FsmGenExtensions.getLinkFor((GraphContainer)this.gc, (TransitionBase)tr);
        for (Link ch : l.getChainHeads()) {
            noIfItem |= ch.getTransition() instanceof InitialTransition;
        }
        if (!FsmGenExtensions.getAllActionCodes((Link)l).isEmpty()) {
            if (noIfItem) {
                return this.codegenHelpers.getActionCodeOperationName(tr) + "(" + this.langExt.selfPointer(false) + ");\n";
            }
            String dataArg = "";
            if (l.getCommonData() != null) {
                dataArg = this.langExt.generateArglistAndTypedData(l.getCommonData())[ILanguageExtensionBase.TypedDataKind.COMMA_SEPARATED_PARAM_IN_CALL.ordinal()];
            }
            return this.codegenHelpers.getActionCodeOperationName(tr) + "(" + this.langExt.selfPointer(true) + "ifitem" + dataArg + ");\n";
        }
        return "";
    }

    @Override
    public String genEntryOperationCall(State state) {
        return this.codegenHelpers.getEntryCodeOperationName(state) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    @Override
    public String genExitOperationCall(State state) {
        return this.codegenHelpers.getExitCodeOperationName(state) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    @Override
    public String genElseIfBranch(CPBranchTransition tr, boolean isFirst) {
        Object result = "";
        if (!isFirst) {
            result = "}\nelse ";
        }
        result = (String)result + "if (" + this.translationProvider.getTranslatedCode(tr.getCondition()) + ") {\n";
        return result;
    }

    @Override
    public String genElseBranch(ContinuationTransition tr) {
        String result = "}\nelse {\n";
        return result;
    }

    @Override
    public String genEndIf() {
        return "}\n";
    }

    @Override
    public String genReturnState(State state, boolean executeEntryCode) {
        if (executeEntryCode) {
            return "return " + this.codegenHelpers.getGenStateId(state) + ";";
        }
        return "return " + this.codegenHelpers.getGenStateId(state) + " + STATE_MAX;";
    }

    @Override
    public String genTypedData(Transition tr) {
        Link l = FsmGenExtensions.getLinkFor((GraphContainer)this.gc, (TransitionBase)tr);
        return this.langExt.generateArglistAndTypedData(l.getCommonData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()];
    }
}

