/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf.layouter;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;

public class Draw2DLayoutProvider
extends AbstractLayoutProvider {
    public static final String PARAM_COMPOUND = "Compound";
    private static final float DEF_MIN_SPACING = 16.0f;
    private boolean compoundMode = false;

    public void initialize(String parameter) {
        this.compoundMode = PARAM_COMPOUND.equals(parameter);
    }

    public void doLayout(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Draw2D Directed Graph layout", 1.0f);
        DirectedGraph graph = this.buildDraw2dGraph(layoutNode);
        CompoundDirectedGraphLayout draw2dLayout = this.compoundMode ? new CompoundDirectedGraphLayout() : new DirectedGraphLayout();
        draw2dLayout.visit(graph);
        this.applyLayout(layoutNode, graph);
        progressMonitor.done();
    }

    private DirectedGraph buildDraw2dGraph(KNode layoutNode) {
        DirectedGraph graph = new DirectedGraph();
        KShapeLayout parentLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        float minSpacing = ((Float)parentLayout.getProperty(LayoutOptions.SPACING)).floatValue();
        if (minSpacing < 0.0f) {
            minSpacing = 16.0f;
        }
        graph.setDefaultPadding(new Insets((int)minSpacing));
        float borderSpacing = ((Float)parentLayout.getProperty(LayoutOptions.BORDER_SPACING)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = 16.0f;
        }
        graph.setMargin(new Insets((int)borderSpacing));
        Direction layoutDirection = (Direction)parentLayout.getProperty(LayoutOptions.DIRECTION);
        switch (layoutDirection) {
            case DOWN: 
            case UP: {
                graph.setDirection(4);
                break;
            }
            default: {
                graph.setDirection(16);
            }
        }
        HashMap<KNode, Node> nodeMap = new HashMap<KNode, Node>();
        for (KNode knode : layoutNode.getChildren()) {
            Node draw2dNode = new Node((Object)knode);
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            KimlUtil.resizeNode((KNode)knode);
            draw2dNode.width = (int)nodeLayout.getWidth();
            draw2dNode.height = (int)nodeLayout.getHeight();
            nodeMap.put(knode, draw2dNode);
            graph.nodes.add((Object)draw2dNode);
        }
        for (KNode source : layoutNode.getChildren()) {
            Node draw2dSource = (Node)nodeMap.get(source);
            for (KEdge kedge : source.getOutgoingEdges()) {
                KNode target = kedge.getTarget();
                Node draw2dTarget = (Node)nodeMap.get(target);
                if (draw2dTarget == null || draw2dTarget == draw2dSource) continue;
                Edge draw2dEdge = new Edge((Object)kedge, draw2dSource, draw2dTarget);
                graph.edges.add((Object)draw2dEdge);
            }
        }
        return graph;
    }

    private void applyLayout(KNode parentNode, DirectedGraph graph) {
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            if (node.data instanceof KNode) {
                KNode knode = (KNode)node.data;
                KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
                nodeLayout.setPos((float)node.x, (float)node.y);
            }
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            if (edge.data instanceof KEdge) {
                KEdge kedge = (KEdge)edge.data;
                KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                edgeLayout.getBendPoints().clear();
                PointList pointList = edge.getPoints();
                KPoint sourcekPoint = edgeLayout.getSourcePoint();
                Point sourcePoint = pointList.getFirstPoint();
                sourcekPoint.setPos((float)sourcePoint.x, (float)sourcePoint.y);
                int j = 1;
                while (j < pointList.size() - 1) {
                    Point point = pointList.getPoint(j);
                    KPoint kpoint = KLayoutDataFactory.eINSTANCE.createKPoint();
                    kpoint.setPos((float)point.x, (float)point.y);
                    edgeLayout.getBendPoints().add((Object)kpoint);
                    ++j;
                }
                KPoint targetkPoint = edgeLayout.getTargetPoint();
                Point targetPoint = pointList.getLastPoint();
                targetkPoint.setPos((float)targetPoint.x, (float)targetPoint.y);
            }
            ++i;
        }
        KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
        KInsets insets = parentLayout.getInsets();
        Dimension layoutSize = graph.getLayoutSize();
        float width = insets.getLeft() + (float)layoutSize.width + insets.getRight();
        float height = insets.getTop() + (float)layoutSize.height + insets.getBottom();
        KimlUtil.resizeNode((KNode)parentNode, (float)width, (float)height, (boolean)false);
    }
}

