/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.force.graph.FBendpoint;
import de.cau.cs.kieler.klay.force.graph.FEdge;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.graph.FLabel;
import de.cau.cs.kieler.klay.force.graph.FNode;
import de.cau.cs.kieler.klay.force.properties.Properties;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsProcessor
extends AbstractAlgorithm {
    private List<FEdge>[] incidence;
    private boolean[] visited;

    private void initialize(FGraph graph) {
        int n = graph.getNodes().size();
        this.incidence = new List[n];
        this.visited = new boolean[n];
        for (FNode node : graph.getNodes()) {
            this.incidence[node.id] = new LinkedList<FEdge>();
        }
        for (FEdge edge : graph.getEdges()) {
            this.incidence[edge.getSource().id].add(edge);
            this.incidence[edge.getTarget().id].add(edge);
        }
    }

    public List<FGraph> split(FGraph graph) {
        Boolean separate = (Boolean)graph.getProperty(LayoutOptions.SEPARATE_CC);
        if (separate == null || separate.booleanValue()) {
            this.initialize(graph);
            LinkedList<FGraph> components = new LinkedList<FGraph>();
            for (FNode node : graph.getNodes()) {
                FGraph comp = this.dfs(node, null);
                if (comp == null) continue;
                comp.copyProperties((IPropertyHolder)graph);
                components.add(comp);
            }
            this.incidence = null;
            this.visited = null;
            if (components.size() > 1) {
                for (FGraph comp : components) {
                    int id = 0;
                    for (FNode node : comp.getNodes()) {
                        node.id = id++;
                    }
                }
            }
            return components;
        }
        return Lists.newArrayList((Object[])new FGraph[]{graph});
    }

    private FGraph dfs(FNode node, FGraph graph) {
        if (!this.visited[node.id]) {
            this.visited[node.id] = true;
            FGraph component = graph;
            if (component == null) {
                component = new FGraph();
            }
            component.getNodes().add(node);
            for (FEdge edge : this.incidence[node.id]) {
                if (edge.getSource() != node) {
                    this.dfs(edge.getSource(), component);
                }
                if (edge.getTarget() != node) {
                    this.dfs(edge.getTarget(), component);
                }
                component.getEdges().add(edge);
                component.getLabels().addAll(edge.getLabels());
            }
            return component;
        }
        return null;
    }

    public FGraph pack(List<FGraph> components) {
        if (components.size() == 1) {
            return components.get(0);
        }
        if (components.size() <= 0) {
            return new FGraph();
        }
        for (FGraph graph : components) {
            int priority = 0;
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            double maxx = -2.147483648E9;
            double maxy = -2.147483648E9;
            for (FNode node : graph.getNodes()) {
                Integer p = (Integer)node.getProperty(LayoutOptions.PRIORITY);
                if (p != null) {
                    priority += p.intValue();
                }
                minx = Math.min(minx, node.getPosition().x);
                miny = Math.min(miny, node.getPosition().y);
                maxx = Math.max(maxx, node.getPosition().x + node.getSize().x);
                maxy = Math.max(maxy, node.getPosition().y + node.getSize().y);
            }
            graph.setProperty((IProperty)Properties.PRIORITY, priority);
            graph.setProperty(Properties.BB_UPLEFT, new KVector(minx, miny));
            graph.setProperty(Properties.BB_LOWRIGHT, new KVector(maxx, maxy));
        }
        Collections.sort(components, new Comparator<FGraph>(){

            @Override
            public int compare(FGraph graph1, FGraph graph2) {
                int prio = (Integer)graph2.getProperty((IProperty)Properties.PRIORITY) - (Integer)graph1.getProperty((IProperty)Properties.PRIORITY);
                if (prio == 0) {
                    KVector size1 = KVector.diff((KVector)((KVector)graph1.getProperty(Properties.BB_LOWRIGHT)), (KVector)((KVector)graph1.getProperty(Properties.BB_UPLEFT)));
                    KVector size2 = KVector.diff((KVector)((KVector)graph2.getProperty(Properties.BB_LOWRIGHT)), (KVector)((KVector)graph2.getProperty(Properties.BB_UPLEFT)));
                    return Double.compare(size1.x * size1.y, size2.x * size2.y);
                }
                return prio;
            }
        });
        FGraph result = new FGraph();
        result.copyProperties((IPropertyHolder)components.get(0));
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (FGraph graph : components) {
            KVector size = KVector.diff((KVector)((KVector)graph.getProperty(Properties.BB_LOWRIGHT)), (KVector)((KVector)graph.getProperty(Properties.BB_UPLEFT)));
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)result.getProperty((IProperty)Properties.ASPECT_RATIO)).floatValue()));
        double spacing = ((Float)result.getProperty((IProperty)Properties.SPACING)).floatValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (FGraph graph : components) {
            KVector size = KVector.diff((KVector)((KVector)graph.getProperty(Properties.BB_LOWRIGHT)), (KVector)((KVector)graph.getProperty(Properties.BB_UPLEFT)));
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.moveGraph(result, graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        return result;
    }

    private void moveGraph(FGraph destGraph, FGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        graphOffset.sub((KVector)sourceGraph.getProperty(Properties.BB_UPLEFT));
        for (FNode node : sourceGraph.getNodes()) {
            node.getPosition().add(graphOffset);
            destGraph.getNodes().add(node);
        }
        for (FEdge edge : sourceGraph.getEdges()) {
            for (FBendpoint bendpoint : edge.getBendpoints()) {
                bendpoint.getPosition().add(graphOffset);
            }
            destGraph.getEdges().add(edge);
        }
        for (FLabel label : sourceGraph.getLabels()) {
            label.getPosition().add(graphOffset);
            destGraph.getLabels().add(label);
        }
    }
}

