/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.dialogs;

import fr.inria.aoste.timesquare.utils.ui.idialog.BasedDialog;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class PartialDialog
extends BasedDialog<IVar> {
    private IVcdDiagram ivcd;

    public PartialDialog(Shell parentShell, String possibleText, String selectedText, IVcdDiagram ivcd, String title) {
        super(parentShell, possibleText, selectedText, title);
        this.ivcd = ivcd;
        this.setUpdown(false);
        TraceCollector tc = ivcd.getTraceCollector();
        this.labelProvider = new MyLabelProvider();
        for (IVar var : tc.getAllnames()) {
            if (var.getValueFactory() == null || !var.getValueFactory().haveGhostinclock()) continue;
            if (var.getValueFactory().getIsGhostVisible()) {
                this.elselect.addElement((Object)var);
                continue;
            }
            this.elsource.addElement((Object)var);
        }
        for (IVar var : tc.getSelectedClocks()) {
            if (!var.getValueFactory().haveGhostinclock()) continue;
            if (var.getValueFactory().getIsGhostVisible()) {
                this.elselect.addElement((Object)var);
                continue;
            }
            this.elsource.addElement((Object)var);
        }
    }

    public int apply() {
        if (this.elsource.isEmpty()) {
            this.ivcd.setGhostMode(Mode.show);
            return 0;
        }
        if (this.elselect.isEmpty()) {
            this.ivcd.setGhostMode(Mode.hide);
            return 1;
        }
        for (IVar var : this.elselect.getElements()) {
            var.getValueFactory().setGhostVisible(true);
        }
        for (IVar var : this.elsource.getElements()) {
            var.getValueFactory().setGhostVisible(false);
        }
        this.ivcd.getVcdmenu().setGhostSelected(Mode.partial);
        return 2;
    }

    protected static class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected MyLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object o) {
            if (o instanceof IVar) {
                return ((IVar)o).getAliasName();
            }
            return o.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (columnIndex == 1) {
                return "toto";
            }
            return "not the right column index";
        }
    }
}

