/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

import fr.inria.aoste.timesquare.vcd.model.VcdAbstractConnectionAnchor;
import fr.inria.aoste.timesquare.vcd.view.Eventline;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class VcdChopboxAnchor
extends VcdAbstractConnectionAnchor {
    private int _ticknum;

    protected VcdChopboxAnchor() {
    }

    public VcdChopboxAnchor(IFigure owner, int ticknum) {
        super(owner, ticknum);
        this._ticknum = ticknum;
    }

    public int getTickNum() {
        return this._ticknum;
    }

    public void setTickNum(int ticknum) {
        this._ticknum = ticknum;
    }

    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getTickBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute((Translatable)r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    protected Rectangle getBox() {
        return this.getOwner().getBounds();
    }

    public Rectangle getTickBox() {
        if (this.getOwner() instanceof Eventline) {
            Eventline cl = (Eventline)this.getOwner();
            int unitStepLength = cl.getUnitStepLength();
            Rectangle rec = cl.getBounds();
            int x = rec.x + this._ticknum * unitStepLength;
            int width = unitStepLength * 2 / 5;
            Rectangle r = Rectangle.SINGLETON;
            r.x = x;
            r.y = rec.y;
            r.width = width;
            r.height = rec.height;
            return r;
        }
        return null;
    }

    @Override
    public Point getReferencePoint() {
        Point ref = this.getTickBox().getCenter();
        this.getOwner().translateToAbsolute((Translatable)ref);
        return ref;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VcdChopboxAnchor) {
            VcdChopboxAnchor other = (VcdChopboxAnchor)((Object)obj);
            return other.getOwner() == this.getOwner() && other.getTickNum() == this.getTickNum();
        }
        return false;
    }

    public int hashCode() {
        if (this.getOwner() != null) {
            return this.getOwner().hashCode();
        }
        return super.hashCode();
    }
}

