/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.relation.extensionpoint.Instant;
import fr.inria.aoste.timesquare.vcd.view.EventPanel;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class Eventline
extends Polyline {
    private String eventName;
    private PointList pointListRef = new PointList();
    private VcdColorPreferences colorPreferences;
    private int lastEvent = -1;
    Boolean drawNoTickCalled = false;
    private int drawZCalledTwice = 0;
    private int _startPointX;
    private int _startPointY;
    private int _endPointX;
    private int _endPointY;
    private int _unitStepLength;
    private int _unitStepLengthRef;
    private int _endPointXRef;
    private int _countInstant = 0;
    private ArrayList<Integer> tickInstants;
    private HashMap<Integer, Boolean> ticksShow;
    private HashMap<Integer, Instant> instants;
    private static int height = 20;

    public Eventline(Point startPoint, int unitStepLength, String eventName, VcdColorPreferences mca) {
        this.colorPreferences = mca;
        this.setOpaque(false);
        this.eventName = eventName;
        this._unitStepLength = unitStepLength * 2;
        this._startPointX = startPoint.x;
        this._startPointY = startPoint.y + height + 5;
        this._endPointX = this._startPointX;
        this._endPointY = this._startPointY;
        this._unitStepLengthRef = this._unitStepLength;
        this._endPointXRef = this._endPointX;
        this.setLineWidth(1);
        this.ticksShow = new HashMap();
        this.tickInstants = new ArrayList();
        this.instants = new HashMap();
        this.setForegroundColor(this.colorPreferences.colorClock());
    }

    public String getEventName() {
        return this.eventName;
    }

    public ArrayList<Integer> getTickInstants() {
        return this.tickInstants;
    }

    public HashMap<Integer, Instant> getIntants() {
        return this.instants;
    }

    public HashMap<Integer, Boolean> getTicksTime() {
        return this.ticksShow;
    }

    public int getPointsSize() {
        return this.getPoints().size();
    }

    public Point getPoint(int index) {
        return this.getPoints().getPoint(index);
    }

    public int getHeight() {
        return height;
    }

    public int getStartPointX() {
        return this._startPointX;
    }

    public void setStartPointX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + x);
        }
        this._startPointX = x;
    }

    public int getStartPointY() {
        return this._startPointY;
    }

    public void setStartPointY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("the y starting point must be positive: " + y);
        }
        this._startPointY = y;
    }

    public int getEndPointX() {
        return this._endPointX;
    }

    public void setEndPointX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + x);
        }
        this._endPointX = x;
    }

    public int getEndPointY() {
        return this._endPointY;
    }

    public void setEndPointY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + y);
        }
        this._endPointY = y;
    }

    public void setStartPoint(Point sp) {
        this._startPointX = sp.x;
        this._startPointY = sp.y;
    }

    public void setEndPoint(Point p) {
        this._endPointX = p.x;
        this._endPointY = p.y;
    }

    public int getUnitStepLength() {
        return this._unitStepLength;
    }

    public void setUnitStepLength(int usl) {
        this._unitStepLength = usl;
    }

    public void drawNoTick(int time) {
        this._endPointX = time * this._unitStepLength / 10 + 5;
        switch (this.lastEvent) {
            case -1: {
                this.addPoint(new Point(this._startPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 0: {
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 1: {
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 2: {
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
        }
        this.lastEvent = 0;
        EventPanel eventlinePanel = (EventPanel)this.getParent();
        eventlinePanel.setPreferredSize(this._endPointX + this._unitStepLength, eventlinePanel.getPreferredSize().height);
    }

    public void drawTick(int time) {
        this._endPointX = time * this._unitStepLength / 10 + 5;
        switch (this.lastEvent) {
            case -1: {
                this.addPoint(new Point(this._startPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 0: {
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 1: {
                if (this.drawZCalledTwice >= 2) {
                    this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX, this._endPointY - height));
                    this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                    this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY - height / 2));
                    break;
                }
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
            case 2: {
                if (this.drawZCalledTwice >= 2) {
                    this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX, this._endPointY - height));
                    this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                    this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY - height / 2));
                    break;
                }
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY - height));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength / 5, this._endPointY));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY));
                break;
            }
        }
        this.lastEvent = 1;
        EventPanel eventlinePanel = (EventPanel)this.getParent();
        eventlinePanel.setPreferredSize(this._endPointX + this._unitStepLength, eventlinePanel.getPreferredSize().height);
        int t = time / 10;
        this.ticksShow.put(t, false);
        this.tickInstants.add(t);
        ++this._countInstant;
        Instant in = new Instant(this.eventName, this._countInstant);
        this.instants.put(t, in);
    }

    public void drawEnd(int time) {
        this._endPointX = time * this._unitStepLength / 10 + 5;
        switch (this.lastEvent) {
            case -1: {
                this.addPoint(new Point(this._startPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._startPointX + 2 * this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 0: {
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 1: {
                if (this.drawZCalledTwice >= 2) {
                    this.removePoint(this.getPoints().size() - 1);
                    this.removePoint(this.getPoints().size() - 1);
                    Point lastPoint = this.getPoints().getLastPoint();
                    this.addPoint(new Point(lastPoint.x, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                    this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength, this._endPointY - height / 2));
                    break;
                }
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 2: {
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + 2 * this._unitStepLength, this._endPointY - height / 2));
                break;
            }
        }
        if (this.drawZCalledTwice >= 2 && !this.drawNoTickCalled.booleanValue()) {
            PointList pl = new PointList();
            pl.addAll(this.getPoints());
            int sizeofpl = pl.size();
            Point p = null;
            int i = 0;
            while (i < sizeofpl) {
                p = pl.getPoint(i);
                if (p.y == this._endPointY) {
                    p.setY(this._endPointY - height / 2);
                }
                pl.setPoint(p, i);
                ++i;
            }
            this.removeAllPoints();
            this.setPoints(pl);
            this.setForegroundColor(this.colorPreferences.colorYellowZ());
        }
        this.lastEvent = 2;
        EventPanel clocklinePanel = (EventPanel)this.getParent();
        clocklinePanel.setPreferredSize(this._endPointX + this._unitStepLength * 5, clocklinePanel.getPreferredSize().height);
        this.pointListRef.addAll(this.getPoints());
    }

    public void drawZ(int time) {
        this._endPointX = time * this._unitStepLength / 10 + 5;
        switch (this.lastEvent) {
            case -1: {
                this.addPoint(new Point(this._startPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._startPointX + this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 0: {
                this.addPoint(new Point(this._endPointX, this._endPointY));
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 1: {
                this.removePoint(this.getPoints().size() - 1);
                this.removePoint(this.getPoints().size() - 1);
                Point lastPoint = this.getPoints().getLastPoint();
                this.addPoint(new Point(lastPoint.x, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY - height / 2));
                break;
            }
            case 2: {
                this.addPoint(new Point(this._endPointX, this._endPointY - height / 2));
                this.addPoint(new Point(this._endPointX + this._unitStepLength, this._endPointY - height / 2));
                break;
            }
        }
        if (this.lastEvent == 1) {
            ++this.drawZCalledTwice;
        }
        this.lastEvent = 2;
        EventPanel clocklinePanel = (EventPanel)this.getParent();
        clocklinePanel.setPreferredSize(this._endPointX + this._unitStepLength, clocklinePanel.getPreferredSize().height);
    }

    public void eventLineZoom(double value) {
        PointList pl = new PointList();
        pl.addAll(this.pointListRef);
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((int)((double)(p.x - this._startPointX) * value + (double)this._startPointX));
            pl.setPoint(p, i);
            ++i;
        }
        this.removeAllPoints();
        this.setPoints(pl);
        this._unitStepLength = (int)((double)this._unitStepLengthRef * value);
        if (sizeofpl < 2) {
            return;
        }
        this._endPointX = pl.getPoint((int)(sizeofpl - 2)).x;
    }

    public void resetDefaultSize() {
        PointList pl = new PointList();
        pl.addAll(this.pointListRef);
        this.removeAllPoints();
        this.setPoints(pl);
        this._unitStepLength = this._unitStepLengthRef;
        this._endPointX = this._endPointXRef;
    }

    public void eventLineZoomIn() {
        PointList pl = new PointList();
        pl.addAll(this.getPoints());
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((p.x - this._startPointX) * 2 + this._startPointX);
            pl.setPoint(p, i);
            ++i;
        }
        this.removeAllPoints();
        this.setPoints(pl);
        this._unitStepLength *= 2;
        this._endPointX = pl.getPoint((int)(sizeofpl - 2)).x;
    }

    public void eventLineZoomOut() {
        PointList pl = new PointList();
        pl.addAll(this.getPoints());
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((p.x - this._startPointX) / 2 + this._startPointX);
            pl.setPoint(p, i);
            ++i;
        }
        this.removeAllPoints();
        this.setPoints(pl);
        this._unitStepLength /= 2;
        this._endPointX = pl.getPoint((int)(sizeofpl - 2)).x;
    }

    public void setEventlineLocation(Point pt) {
        PointList pl = this.getPoints();
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setY(p.y + pt.y + height + 5 - this._startPointY);
            pl.setPoint(p, i);
            p = this.pointListRef.getPoint(i);
            p.setY(p.y + pt.y + height + 5 - this._startPointY);
            this.pointListRef.setPoint(p, i);
            ++i;
        }
        this.setPoints(pl);
        this._startPointY = pt.y + height + 5;
        this._endPointY = pt.y + height + 5;
    }

    public void clear() {
        this.tickInstants.clear();
        this.ticksShow.clear();
        this.instants.clear();
        this.tickInstants = null;
        this.ticksShow = null;
        this.instants = null;
        this.pointListRef = null;
    }
}

