/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.VcdZoom;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.Timeline;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.ConstraintsFactory;
import fr.inria.aoste.timesquare.vcd.view.EventPanel;
import fr.inria.aoste.timesquare.vcd.view.Eventline;
import fr.inria.aoste.timesquare.vcd.view.MarkerFactory;
import fr.inria.aoste.timesquare.vcd.view.VcdValueFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;

public final class VcdFactory {
    private static final int _halfHeight = 10;
    private static final int _height = 20;
    private static final int dY = 5;
    private static final int nameWidth = 0;
    private static final int y = 5;
    private int _endTime = -1;
    private VcdZoom _vcdZoom = null;
    private IVcdDiagram _vcdDiagram = null;
    private Timeline _timeline;
    private Panel _timelinePanel;
    private Panel _backPanel;
    private Panel namesP;
    private Panel _picture;
    private Rectangle _backPanelBounds = new Rectangle();
    private HashMap<ExtendFigure, Description> figurefordescription = new HashMap();
    private HashMap<String, ArrayList<ExtendFigure>> nameforfigures = new HashMap();
    private ArrayList<RectangleFigure> ghostList = new ArrayList();
    private ConstraintsFactory _constraintsFactory;
    private MarkerFactory _markerFactory;
    private VcdColorPreferences _mca = null;
    private HashMap<String, EventPanel> _clockPanelsXmiMap = new HashMap();
    private HashMap<String, Eventline> _clocklinesXmiMap = new HashMap();
    private HashMap<String, EventPanel> _clockPanelsMap = new HashMap();
    private HashMap<String, Eventline> _clocklinesMap = new HashMap();
    private VCDDefinitions _vcdDef = null;
    int _scaleRange = 100;

    public Timeline getTimeline() {
        return this._timeline;
    }

    public void setTimeline(Timeline tl) {
        this._timeline = tl;
    }

    public final int getHalfHeight() {
        return 10;
    }

    public final int getNameWidth() {
        return 0;
    }

    public final int getHeight() {
        return 20;
    }

    public VcdColorPreferences getMca() {
        return this._mca;
    }

    public HashMap<String, Eventline> getClocklinesXmiMap() {
        return this._clocklinesXmiMap;
    }

    public HashMap<String, EventPanel> getClockPanelsXmiMap() {
        return this._clockPanelsXmiMap;
    }

    public HashMap<String, Eventline> getClocklinesMap() {
        return this._clocklinesMap;
    }

    public HashMap<String, EventPanel> getClockPanelsMap() {
        return this._clockPanelsMap;
    }

    public void drawTick(int time, String panelName) {
        Eventline el = this._clockPanelsXmiMap.get(panelName).getEventline();
        el.drawTick(time);
    }

    public void drawNoTick(int time, String panelName) {
        Eventline el = this._clockPanelsXmiMap.get(panelName).getEventline();
        el.drawNoTick(time);
    }

    public void drawEnd(int time, String panelName) {
        Eventline el = this._clockPanelsXmiMap.get(panelName).getEventline();
        el.drawEnd(time);
    }

    public void drawZ(int time, String panelName) {
        Eventline el = this._clockPanelsXmiMap.get(panelName).getEventline();
        el.drawZ(time);
    }

    public VcdFactory(VcdColorPreferences mcain) {
        this._mca = mcain;
        if (this._mca == null) {
            this._mca = VcdColorPreferences.createColor();
        }
        this._timeline = new Timeline(new Point(5, 0), 10, this._mca);
        GridLayout layout = null;
        layout = new GridLayout(1, true);
        layout.marginHeight = 25;
        this.namesP = new Panel();
        this.namesP.setBackgroundColor(this._mca.colorBlack());
        this.namesP.setOpaque(true);
        this.namesP.setLayoutManager((LayoutManager)layout);
        this._backPanel = new Panel();
        this._backPanel.setBackgroundColor(this._mca.colorBlack());
        this._backPanel.setOpaque(false);
        layout = new GridLayout(1, true);
        layout.marginHeight = 25;
        this._backPanel.setLayoutManager((LayoutManager)layout);
        layout = new GridLayout(1, true);
        layout.marginHeight = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this._timelinePanel = new Panel();
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this._timelinePanel.setBackgroundColor(this._mca.colorBlack());
        this._timelinePanel.setOpaque(false);
        this._timelinePanel.setLayoutManager((LayoutManager)layout);
        this._timelinePanel.setSize(-1, 35);
        this._timelinePanel.add((IFigure)this._timeline);
        this._picture = new Panel();
        this._picture.setBackgroundColor(this._mca.colorBlack());
        this._picture.setOpaque(false);
        this._picture.setLayoutManager((LayoutManager)layout);
        this._picture.setSize(120, 35);
    }

    public VcdValueFactory initVcdValueFactory(IVar var, double zoom) {
        Eventline cl;
        EventPanel ep;
        Object obj = var.getData("xmi");
        String clockXmiId = null;
        if (obj instanceof String) {
            clockXmiId = ((String)obj).substring(((String)obj).indexOf("#") + 1);
        }
        String name = var.getName();
        String text = var.getAliasName();
        if (clockXmiId == null) {
            ep = new EventPanel(this._constraintsFactory, this, name, text, this._mca);
            ep.setBackgroundColor(this._mca.colorBlack());
            ep.setPreferredSize(new Dimension(2000, 35));
            this._backPanel.add((IFigure)ep);
            this._backPanelBounds.setBounds(ep.getBounds());
            this._backPanel.getLayoutManager().layout((IFigure)this._backPanel);
            cl = new Eventline(ep.getLocation(), 10, name, this._mca);
            ep.initEventPanel(cl);
            ep.setBounds(cl.getBounds());
            this._clockPanelsXmiMap.put(name, ep);
            this._clocklinesXmiMap.put(name, cl);
        } else {
            ep = new EventPanel(this._constraintsFactory, this, clockXmiId, name, text, this._mca);
            ep.setBackgroundColor(this._mca.colorBlack());
            ep.setPreferredSize(new Dimension(2000, 35));
            this._backPanel.add((IFigure)ep);
            this._backPanelBounds.setBounds(ep.getBounds());
            this._backPanel.getLayoutManager().layout((IFigure)this._backPanel);
            cl = new Eventline(ep.getLocation(), 10, clockXmiId, this._mca);
            ep.initEventPanel(cl);
            ep.setBounds(cl.getBounds());
            this._clockPanelsXmiMap.put(clockXmiId, ep);
            this._clocklinesXmiMap.put(clockXmiId, cl);
            this._clockPanelsMap.put(name, ep);
            this._clocklinesMap.put(name, cl);
        }
        Label l = new Label(text);
        RectangleFigure rectangle = new RectangleFigure();
        int size = this._mca.getWidthName() - 10;
        rectangle.setOpaque(false);
        rectangle.setLineStyle(3);
        rectangle.setForegroundColor(this._mca.colorLightGrayClockNameContour());
        rectangle.setBounds(new Rectangle(0, 0, size, 35));
        l.setBounds(new Rectangle(1, 1, size - 4, 30));
        l.setForegroundColor(this._mca.colorWhiteText());
        l.setOpaque(true);
        Font font = new Font(null, "Arial", 10, 1);
        l.setFont(font);
        rectangle.add((IFigure)l);
        this.namesP.add((IFigure)rectangle);
        ToolTipRectangle tiprectangle = new ToolTipRectangle(var);
        rectangle.setToolTip((IFigure)tiprectangle);
        if (var.getValueFactory() != null) {
            var.getValueFactory().clear();
        }
        VcdValueFactory out = new VcdValueFactory(var.getVarCommand(), this, 5, zoom);
        var.setValueFactory(out);
        return out;
    }

    public Panel getNames() {
        return this.namesP;
    }

    public Panel getScalePanel() {
        return this._timelinePanel;
    }

    public Panel getBackPanel() {
        return this._backPanel;
    }

    public int getWindowsBoundsLength() {
        return this._backPanelBounds.getSize().width;
    }

    public int getHeigth() {
        int n = 0;
        for (Object p : this._backPanel.getChildren()) {
            if (!(p instanceof Panel)) continue;
            ++n;
        }
        return (n + 1) * 40 + 40;
    }

    public Panel getPicture() {
        return this._picture;
    }

    public Description getFigureForDescription(IFigure ef) {
        return this.figurefordescription.get(ef);
    }

    public HashMap<String, ArrayList<ExtendFigure>> getNameforfigures() {
        return this.nameforfigures;
    }

    public ConstraintsFactory getConstraintsFactory() {
        return this._constraintsFactory;
    }

    public void setConstraintsFactory(ConstraintsFactory constraintsFactory) {
        this._constraintsFactory = constraintsFactory;
    }

    public MarkerFactory getMarkerFactory() {
        return this._markerFactory;
    }

    public void setMarkerFactory(MarkerFactory markerFactory) {
        this._markerFactory = markerFactory;
    }

    public VCDDefinitions getVcdDefinitions() {
        return this._vcdDef;
    }

    public void setVcdDef(VCDDefinitions vcd) {
        this._vcdDef = vcd;
    }

    public int getScaleRange() {
        return this._scaleRange;
    }

    public void setScaleRange(int _scaleRange) {
        if (_scaleRange != 0) {
            this._scaleRange = _scaleRange;
        }
    }

    public int modifyTimeLineSize(int currentTime) {
        if (this._endTime > currentTime) {
            return 0;
        }
        if (this._endTime == currentTime) {
            return 0;
        }
        if (currentTime % 100 == 0) {
            this._timeline.extendTimeLine(this._vcdDef.getTimeLabelling().getRulerTimeIndice(currentTime));
        }
        this._endTime = currentTime;
        return 0;
    }

    public VcdZoom getVcdZoom() {
        return this._vcdZoom;
    }

    public void setVcdZoom(VcdZoom _vcdZoom2) {
        this._vcdZoom = _vcdZoom2;
    }

    public IVcdDiagram getVcddia() {
        return this._vcdDiagram;
    }

    public void setVcddia(IVcdDiagram vcddia) {
        this._vcdDiagram = vcddia;
    }

    public void clear2() {
        this.ghostList.clear();
        for (Panel panel : this._clockPanelsXmiMap.values()) {
            panel.removeAll();
            panel.erase();
            panel.repaint();
        }
        this._clockPanelsXmiMap.clear();
        for (ArrayList arrayList : this.nameforfigures.values()) {
            for (IFigure ifi : arrayList) {
                if (ifi == null) continue;
                ifi.erase();
            }
            arrayList.clear();
        }
        this.nameforfigures.clear();
    }

    public void clear() {
        this.figurefordescription.clear();
        this.ghostList.clear();
        for (Eventline cl : this._clocklinesMap.values()) {
            cl.getIntants().clear();
            cl.getTickInstants().clear();
            cl.getTicksTime().clear();
            cl.erase();
        }
        for (EventPanel eventPanel : this._clockPanelsMap.values()) {
            eventPanel.removeAll();
            eventPanel.erase();
            eventPanel.repaint();
        }
        this._clockPanelsMap.clear();
        this._clockPanelsMap.clear();
        this._clocklinesMap.clear();
        this._timeline.getLabels().clear();
        this._timeline.removeAll();
        this._timeline.removeAllPoints();
        this._timelinePanel.removeAll();
        this._backPanel.removeAll();
        this.namesP.removeAll();
        this._picture.removeAll();
        this._timelinePanel.erase();
        this._backPanel.erase();
        this.namesP.erase();
        this._picture.erase();
        this._timeline = null;
        this._clocklinesXmiMap = null;
        this._constraintsFactory = null;
        this._markerFactory = null;
        this._mca = null;
        this._vcdDiagram = null;
        this._vcdZoom = null;
        this.nameforfigures = null;
    }

    void add(ExtendFigure f, Description description, boolean b) {
        if (f == null) {
            return;
        }
        this._backPanelBounds = this._backPanelBounds.getUnion(f.getBounds());
        this._backPanel.getLayoutManager().layout((IFigure)this._backPanel);
        Point location = null;
        if (this._clockPanelsXmiMap.get(description.getName()) != null) {
            EventPanel ep = this._clockPanelsXmiMap.get(description.getName());
            location = ep.getLocation();
            ep.getClientArea().getUnion(f.getBounds());
            if (f instanceof PolylineConnection) {
                PolylineConnection fig = (PolylineConnection)f;
                fig.getPoints().translate(location);
                f.setTr(location);
                f.mycompute();
            }
            if (f instanceof Polygon) {
                Polygon poly = (Polygon)f;
                poly.getPoints().translate(location);
                for (Object l : poly.getChildren()) {
                    if (!(l instanceof Label)) continue;
                    ((Label)l).setBounds(((Label)l).getBounds().translate(location));
                }
                poly.setBounds(poly.getBounds().translate(location));
                f.setTr(location);
                f.mycompute();
            }
            ep.add(f);
            ep.setDurationModel();
            ep.setPreferredSize(f.getBounds().x + f.getLength(), ep.getBounds().height);
        }
    }

    private final class ToolTipRectangle
    extends RectangleFigure {
        private IVar _variable = null;
        private Label _label = null;

        public ToolTipRectangle(IVar _variable) {
            int n = _variable.getName().length() + 8;
            this._variable = _variable;
            this.setOpaque(true);
            this.setOutline(false);
            this.setForegroundColor(ColorConstants.gray);
            this.setBackgroundColor(ColorConstants.lightGray);
            this.setBounds(new Rectangle(0, 0, 8 * n + 10, 58));
            this._label = new Label();
            this._label.setText("default ");
            this._label.setBounds(new Rectangle(5, 3, 8 * n, 53));
            this._label.setForegroundColor(ColorConstants.black);
            this._label.setBackgroundColor(ColorConstants.lightGray);
            this._label.setOpaque(true);
            this.add((IFigure)this._label);
        }

        public boolean isVisible() {
            return super.isVisible();
        }

        public void setBounds(Rectangle rect) {
            super.setBounds(rect);
        }

        public void repaint() {
            if (this._label != null) {
                if (this._variable != null) {
                    String _str = null;
                    boolean _bool = this._variable.getName().compareTo(this._variable.getAliasName()) != 0;
                    _str = "Name:\t" + this._variable.getAliasName() + "\n\t";
                    if (_bool) {
                        _str = String.valueOf(_str) + "or\t" + this._variable.getName() + "\n";
                    }
                    if (this._variable.getValueFactory() != null) {
                        _str = String.valueOf(_str) + "Nb of Tc: \t" + this._variable.getValueFactory().getTickNum() + "\n";
                        _str = String.valueOf(_str) + "Ghost: \t" + this._variable.getValueFactory().haveGhostinclock();
                        if (this._variable.getValueFactory().haveGhostinclock()) {
                            _str = String.valueOf(_str) + "\nNb of Ghosts: \t" + this._variable.getValueFactory().getNbGhost();
                        }
                    }
                    this._label.setText(_str);
                    this._label.setSize(this._label.getPreferredSize());
                    this.setSize(this._label.getPreferredSize().expand(10, 6));
                    this._label.repaint();
                } else {
                    this._label.setText("nothing");
                }
            }
            super.repaint();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }
    }
}

