/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.handlers;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramPart;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.utils.MessageActionUtil;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.E4PartWrapper;

public abstract class IdeActionHandler
extends AbstractHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPartSite partSite = HandlerUtil.getActivePart((ExecutionEvent)event).getSite();
        this.execute(this.getContext(partSite));
        return null;
    }

    protected IEclipseContext getContext(IWorkbenchPartSite partSite) {
        E4PartWrapper wrapper;
        GLSPDiagramPart part;
        if (partSite.getPart() instanceof E4PartWrapper && (part = (GLSPDiagramPart)(wrapper = (E4PartWrapper)partSite.getPart()).getAdapter(GLSPDiagramPart.class)) != null) {
            return part.getPart().getContext();
        }
        return (IEclipseContext)partSite.getService(IEclipseContext.class);
    }

    protected abstract void execute(IEclipseContext var1);

    protected void dispatchMessage(IEclipseContext context, Action action) {
        ActionDispatcher dispatcher = (ActionDispatcher)context.get(ActionDispatcher.class);
        if (dispatcher == null) {
            return;
        }
        String clientId = (String)context.get("GLSP_CLIENT_ID");
        Optional<GLSPClient> client = Optional.ofNullable((GLSPClient)context.get(GLSPClient.class));
        dispatcher.dispatch(action).exceptionally(ex -> this.handleError((Throwable)ex, client, clientId, action));
    }

    protected <T> Optional<T> getInstance(IEclipseContext context, Class<T> type) {
        GLSPDiagramComposite diagramComposite = (GLSPDiagramComposite)context.get(GLSPDiagramComposite.class);
        return diagramComposite != null ? Optional.ofNullable(diagramComposite.getInjector().getInstance(type)) : Optional.empty();
    }

    protected Optional<GModelState> getModelState(IEclipseContext context) {
        return this.getInstance(context, GModelState.class);
    }

    protected Void handleError(Throwable ex, Optional<GLSPClient> client, String clientId, Action action) {
        String errorMsg = "Could not process action:" + action;
        this.log.error("[ERROR] " + errorMsg, ex);
        client.ifPresent(c -> c.process(new ActionMessage(clientId, (Action)MessageActionUtil.error((String)("[GLSP-Server] " + errorMsg), (Throwable)ex))));
        return null;
    }
}

