/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.actions.handlers;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.glsp.ide.editor.utils.IdeClientOptions;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.navigation.JsonOpenerOptions;
import org.eclipse.glsp.server.features.navigation.NavigateToExternalTargetAction;
import org.eclipse.glsp.server.features.navigation.NavigationTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class IdeNavigateToExternalTargetActionHandler
extends AbstractActionHandler<NavigateToExternalTargetAction> {
    private static final Logger LOGGER = LogManager.getLogger(IdeNavigateToExternalTargetActionHandler.class);

    protected List<Action> executeAction(NavigateToExternalTargetAction action) {
        NavigationTarget target = action.getTarget();
        if (!target.getArgs().containsKey("jsonOpenerOptions")) {
            return this.none();
        }
        String jsonOpenerOptions = (String)target.getArgs().get("jsonOpenerOptions");
        Optional options = JsonOpenerOptions.fromJson((String)jsonOpenerOptions);
        if (options.isEmpty()) {
            LOGGER.warn("Invalid format of JSON opener options: " + jsonOpenerOptions);
            return this.none();
        }
        Optional<IFile> workspaceFile = IdeClientOptions.getUriAsIFile(target.getUri());
        if (workspaceFile.isPresent()) {
            UIUtil.asyncExec(() -> this.openFile((IFile)workspaceFile.get(), (JsonOpenerOptions)options.get()));
        } else {
            LOGGER.warn("Could not find workspace file for " + target.getUri());
        }
        return this.none();
    }

    protected void openFile(IFile file, JsonOpenerOptions options) {
        Optional<IWorkbenchPage> activePage = UIUtil.getActivePage();
        if (activePage.isEmpty()) {
            LOGGER.warn("Could not find activate page to open file " + file);
            return;
        }
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage.get(), (IFile)file);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                IRegion selection = this.translateSelection(textEditor, options.getSelection());
                textEditor.selectAndReveal(selection.getOffset(), selection.getLength());
            }
        }
        catch (BadLocationException | PartInitException exception) {
            LOGGER.error("Could not open file " + file + " with options " + options, exception);
        }
    }

    protected IRegion translateSelection(ITextEditor editor, JsonOpenerOptions.TextSelection textSelection) throws BadLocationException {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        IRegion startLine = document.getLineInformation(textSelection.getStart().getLine());
        IRegion endLine = document.getLineInformation(textSelection.getEnd().getLine());
        int startOffset = startLine.getOffset() + textSelection.getStart().getCharacter();
        int endOffset = endLine.getOffset() + textSelection.getEnd().getCharacter();
        int length = endOffset - startOffset;
        return new Region(startOffset, length);
    }
}

