/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import java.util.function.Supplier;
import org.eclipse.glsp.ide.editor.IdeGLSPClient;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.InitializeClientSessionParameters;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;

public class IdeMessageConsumer
implements MessageConsumer {
    protected IdeGLSPClient ideGLSPClient;
    protected MessageConsumer delegate;
    protected Supplier<GLSPClient> clientProxySupplier;

    public IdeMessageConsumer(IdeGLSPClient ideGLSPClient, Supplier<GLSPClient> clientProxySupplier, MessageConsumer delegate) {
        this.ideGLSPClient = ideGLSPClient;
        this.delegate = delegate;
        this.clientProxySupplier = clientProxySupplier;
    }

    public void consume(Message message) throws MessageIssueException, JsonRpcException {
        if (message instanceof RequestMessage) {
            this.handle((RequestMessage)message);
        }
        this.delegate.consume(message);
    }

    protected void handle(RequestMessage message) {
        if (message.getMethod().equals("initializeClientSession")) {
            InitializeClientSessionParameters params = (InitializeClientSessionParameters)message.getParams();
            this.ideGLSPClient.connect(params.getClientSessionId(), this.clientProxySupplier.get());
        }
    }
}

