/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.features.core.model.ModelFactory;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.jsonrpc.GraphGsonConfiguratorFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptions;

public class JsonFileModelFactory
implements ModelFactory {
    @Inject
    private GraphGsonConfiguratorFactory gsonConfigurationFactory;
    private GModelRoot modelRoot;

    @Override
    public GModelRoot loadModel(RequestModelAction action, GModelState modelState) {
        Optional<File> file = ClientOptions.getSourceUriAsFile(action.getOptions());
        if (file.isPresent() && file.get().exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.get()), StandardCharsets.UTF_8);){
                    Gson gson = this.gsonConfigurationFactory.configureGson().create();
                    this.modelRoot = (GModelRoot)gson.fromJson((Reader)reader, GGraph.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new GLSPServerException("Could not load model from file: " + file.get().toURI().toString(), e);
            }
        }
        return this.modelRoot;
    }
}

