/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.core.model.SetModelAction;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.layout.ILayoutEngine;
import org.eclipse.glsp.server.layout.ServerLayoutConfiguration;
import org.eclipse.glsp.server.layout.ServerLayoutKind;
import org.eclipse.glsp.server.model.GModelState;

@Singleton
public class ModelSubmissionHandler {
    @Inject(optional=true)
    protected ILayoutEngine layoutEngine = new ILayoutEngine.NullImpl();
    @Inject
    protected ServerLayoutConfiguration serverConfiguration;
    private final Object modelLock = new Object();
    private final int revision = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> doSubmitModel(boolean update, GModelState modelState) {
        GModelRoot newRoot = (GModelRoot)modelState.getRoot();
        if (this.serverConfiguration.getLayoutKind() == ServerLayoutKind.AUTOMATIC) {
            this.layoutEngine.layout(modelState);
        }
        Object object = this.modelLock;
        synchronized (object) {
            if (newRoot.getRevision() == 0) {
                if (update) {
                    return Arrays.asList(new UpdateModelAction(newRoot, true));
                }
                return Arrays.asList(new SetModelAction(newRoot));
            }
        }
        return Collections.emptyList();
    }

    public synchronized Object getModelLock() {
        return this.modelLock;
    }
}

