/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.File;
import java.util.Map;
import java.util.Optional;

public final class ClientOptions {
    public static final String DIAGRAM_TYPE = "diagramType";
    public static final String SOURCE_URI = "sourceUri";
    private static final String FILE_PREFIX = "file://";
    public static final String NEEDS_CLIENT_LAYOUT = "needsClientLayout";

    private ClientOptions() {
    }

    public static Optional<String> getValue(Map<String, String> options, String key) {
        return Optional.ofNullable(options).map(opt -> (String)opt.get(key));
    }

    public static Optional<Integer> getIntValue(Map<String, String> options, String key) {
        try {
            return Optional.ofNullable(options).map(opt -> Integer.parseInt((String)opt.get(key)));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static Optional<Float> getFloatValue(Map<String, String> options, String key) {
        try {
            return Optional.ofNullable(options).map(opt -> Float.valueOf(Float.parseFloat((String)opt.get(key))));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static boolean getBoolValue(Map<String, String> options, String key) {
        return Optional.ofNullable(options).map(opt -> Boolean.parseBoolean((String)opt.get(key))).orElse(false);
    }

    public static Optional<File> getSourceUriAsFile(Map<String, String> options) {
        Optional<String> uriString = ClientOptions.getValue(options, SOURCE_URI);
        return uriString.map(uri -> uri.replace(FILE_PREFIX, "")).map(path -> new File((String)path));
    }
}

