/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf;

import com.google.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.emf.EMFIdGenerator;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.model.DefaultGModelState;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionListener;
import org.eclipse.glsp.server.session.ClientSessionManager;

public class EMFModelState
extends DefaultGModelState
implements ClientSessionListener {
    private static Logger LOGGER = LogManager.getLogger((String)EMFModelState.class.getSimpleName());
    @Inject
    protected ClientSessionManager clientSessionManager;
    @Inject
    protected EMFIdGenerator idGenerator;
    protected EditingDomain editingDomain;

    @Inject
    public void init() {
        this.clientSessionManager.addListener((ClientSessionListener)this, new String[]{this.clientId});
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.setCommandStack(this.editingDomain.getCommandStack());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ResourceSet getResourceSet() {
        return this.editingDomain == null ? null : this.editingDomain.getResourceSet();
    }

    protected GModelIndex getOrUpdateIndex(GModelRoot newRoot) {
        return EMFModelIndex.getOrCreate((GModelElement)this.getRoot(), this.idGenerator);
    }

    public EMFModelIndex getIndex() {
        return (EMFModelIndex)super.getIndex();
    }

    public void sessionDisposed(ClientSession clientSession) {
        this.index.clear();
        this.closeResourceSet();
    }

    protected void closeResourceSet() {
        if (this.getResourceSet() == null) {
            return;
        }
        boolean result = false;
        EList resourceList = this.getResourceSet().getResources();
        for (Resource resource : resourceList) {
            if (resource.getURI() == null) continue;
            try {
                resource.unload();
                result = true;
            }
            catch (RuntimeException e) {
                result = false;
                LOGGER.error("Could not unload resource: " + resource.getURI(), (Throwable)e);
                break;
            }
        }
        if (result) {
            this.commandStack.flush();
            this.saveIsDone();
        }
    }
}

