/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.core.model.SourceModelStorage;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public class GModelStorage
implements SourceModelStorage {
    private static Logger LOGGER = LogManager.getLogger(GModelStorage.class);
    private static String EMPTY_ROOT_ID = "glsp-graph";
    @Inject
    protected GModelState modelState;
    protected Gson gson;

    @Inject
    public void configureGson(GraphGsonConfigurationFactory gsonConfigurator) {
        this.gson = gsonConfigurator.configureGson().setPrettyPrinting().create();
    }

    @Override
    public void loadSourceModel(RequestModelAction action) {
        File file = this.convertToFile(action.getOptions());
        this.loadSourceModel(file, this.modelState).ifPresent(root -> {
            this.modelState.updateRoot(root);
            ((GModelRoot)this.modelState.getRoot()).setRevision(-1);
        });
    }

    protected Optional<GModelRoot> loadSourceModel(File file, GModelState modelState) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                GGraph root = (GGraph)this.gson.fromJson((Reader)reader, GGraph.class);
                if (root == null) {
                    boolean isEmpty;
                    boolean bl = isEmpty = file.length() == 0L;
                    if (isEmpty) {
                        return Optional.of(this.createNewEmptyRoot(modelState));
                    }
                    throw new IOException("Could not deserialize file contents of: " + file.toURI().toString());
                }
                return Optional.ofNullable(root);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            throw new GLSPServerException("Could not load model from file: " + file.toURI().toString(), e);
        }
    }

    protected GModelRoot createNewEmptyRoot(GModelState modelState) {
        GGraph root = GraphFactory.eINSTANCE.createGGraph();
        root.setId(EMPTY_ROOT_ID);
        root.setType("graph");
        return root;
    }

    @Override
    public void saveSourceModel(SaveModelAction action) {
        File file = this.convertToFile(action);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                this.gson.toJson(this.modelState.getRoot(), GGraph.class, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            throw new GLSPServerException("An error occured during save process.", e);
        }
    }

    protected File convertToFile(SaveModelAction action) {
        if (action.getFileUri().isPresent()) {
            return ClientOptionsUtil.getAsFile(action.getFileUri().get());
        }
        return this.convertToFile(this.modelState.getClientOptions());
    }

    protected File convertToFile(Map<String, String> clientOptions) {
        return GLSPServerException.getOrThrow(ClientOptionsUtil.getSourceUriAsFile(clientOptions), "Invalid file URI:" + ClientOptionsUtil.getSourceUri(clientOptions));
    }
}

